/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.result;

import com.ibm.bi.predict.fastpattern.chaid.Tree;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.fastpattern.result.CaptionedMessage;
import com.ibm.bi.predict.fastpattern.result.FastPatternResult;
import com.ibm.bi.predict.messages.PredictiveStrengthMessageProvider;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.Locale;

public class TreeResultAnnotator {
    private PredictiveStrengthMessageProvider messageProvider;
    private static final Logger LOG = PredictLoggerFactory.getLogger(TreeResultAnnotator.class);

    public TreeResultAnnotator(Locale locale) {
        this.messageProvider = new PredictiveStrengthMessageProvider("Predict_Smart_Annotations", locale);
    }

    public void addMessage(FastPatternResult result) {
        try {
            List<KeyDriver> keyDrivers = result.getKeyDrivers();
            for (KeyDriver keyDriver : keyDrivers) {
                if (!(keyDriver instanceof Tree)) continue;
                result.getMessages().add(this.makeMessage((Tree)keyDriver));
            }
        }
        catch (Exception e) {
            LOG.warn("Creation of tree predictive strength message failed: ", (Throwable)e);
        }
    }

    private CaptionedMessage makeMessage(Tree tree) {
        Object[] params = this.makeParameters(tree);
        return new CaptionedMessage(this.messageProvider.getId(), this.messageProvider.getCaption(), this.messageProvider.getMessage(new Object[]{tree.getAccuracy()}), this.messageProvider.getMessage(params));
    }

    private Object[] makeParameters(Tree tree) {
        int size = tree.getFieldIds().length;
        Object[] params = new Object[size + 2];
        System.arraycopy(this.getFieldLabels(tree), 0, params, 0, size);
        params[size] = tree.getDecisionTree().target().getLabel();
        params[size + 1] = tree.getAccuracy();
        return params;
    }

    private String[] getFieldLabels(Tree tree) {
        return (String[])tree.getInputFields().stream().map(field -> field.getLabel()).toArray(String[]::new);
    }
}

