/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.util;

import com.ibm.bi.predict.dataaccess.MetaData;
import com.ibm.bi.predict.dataaccess.types.FieldType;
import com.ibm.bi.predict.exceptions.PredictException;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class ParamsConverter {
    private static final String VERSION = "version";
    private static final String LOCALE = "locale";
    private static final String TARGET = "target";
    private static final String INPUTS = "inputs";
    private static final String DATA_ITEMS = "dataItems";
    private static final String METHODS = "methods";
    private static final String SAMPLED_DATA = "sampledData";
    private static final String ID = "id";
    private static final String TYPE = "type";

    private ParamsConverter() {
    }

    public static JSONObject shimFPDParams(MetaData metadata, JSONObject fpdParams) {
        try {
            JSONObject params = new JSONObject();
            params.put(VERSION, (Object)fpdParams.getString(VERSION));
            params.put(TARGET, (Map)ParamsConverter.fieldFromIndex(metadata, fpdParams.getInt(TARGET)));
            params.put(INPUTS, (Collection)ParamsConverter.dataItemsToInputs(metadata, fpdParams.getJSONArray(DATA_ITEMS)));
            if (fpdParams.containsKey((Object)LOCALE)) {
                params.put(LOCALE, (Object)fpdParams.getString(LOCALE));
            }
            if (fpdParams.containsKey((Object)METHODS)) {
                params.put(METHODS, (Collection)fpdParams.getJSONArray(METHODS));
            }
            if (fpdParams.containsKey((Object)SAMPLED_DATA)) {
                params.put(SAMPLED_DATA, fpdParams.getBoolean(SAMPLED_DATA));
            }
            return params;
        }
        catch (JSONException e) {
            throw new PredictException("Error while creating FPD params. Reason: " + e.getMessage(), (Throwable)e);
        }
    }

    private static JSONArray dataItemsToInputs(MetaData metadata, JSONArray dataItems) {
        JSONArray inputs = new JSONArray();
        for (Object o : dataItems) {
            if (!(o instanceof Integer)) {
                throw new PredictException("Expected data items to contain list of indexes");
            }
            int dataItemIndex = (Integer)o;
            inputs.add((Object)ParamsConverter.fieldFromIndex(metadata, dataItemIndex));
        }
        return inputs;
    }

    private static JSONObject fieldFromIndex(MetaData metadata, int fieldIndex) {
        try {
            FieldType type = metadata.getFieldType(fieldIndex);
            String typeStr = type == FieldType.NUMERICAL ? "continuous" : "categorical";
            JSONObject field = new JSONObject();
            field.put(ID, (Object)metadata.getFieldIdentifier(fieldIndex));
            field.put(TYPE, (Object)typeStr);
            return field;
        }
        catch (JSONException e) {
            throw new PredictException("Error while creating field object. Reason: " + e.getMessage(), (Throwable)e);
        }
    }
}

