/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.visrecommender;

import com.ibm.bi.predict.data.DataColumn;
import com.ibm.bi.predict.explore.visrecommender.VisRecommender;
import com.ibm.bi.predict.fastpattern.keydrivers.KeyDriver;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.util.List;
import java.util.Locale;

public class FPDVisRecommender {
    private static final Logger LOGGER = PredictLoggerFactory.getLogger(FPDVisRecommender.class);
    private final VisRecommender recommender;

    public FPDVisRecommender(List<DataColumn.ColumnMeta> fieldInfo, Locale locale) {
        this.recommender = new VisRecommender(fieldInfo, locale);
    }

    public void process(List<KeyDriver> drivers) {
        for (KeyDriver d : drivers) {
            this.process(d);
        }
    }

    public void process(KeyDriver driver) {
        switch (driver.getType()) {
            case ONE_WAY: {
                this.processOneWay(driver);
                break;
            }
            case TWO_WAY: {
                this.processTwoWay(driver);
                break;
            }
            case TREE: {
                this.processTree(driver);
                break;
            }
        }
    }

    private void processOneWay(KeyDriver driver) {
        String[] inputs = driver.getFieldIds();
        if (inputs.length != 1) {
            LOGGER.warn("VISREC: Got one-way key driver with " + inputs.length + " inputs");
        } else {
            driver.addVisRecommendations(this.recommender.oneway(driver.getTargetId(), inputs[0]));
        }
    }

    private void processTwoWay(KeyDriver driver) {
        String[] inputs = driver.getFieldIds();
        if (inputs.length != 2) {
            LOGGER.warn("VISREC: Got two-way driver with " + inputs.length + " inputs");
        } else {
            driver.addVisRecommendations(this.recommender.twoway(driver.getTargetId(), inputs[0], inputs[1]));
        }
    }

    private void processTree(KeyDriver driver) {
        String[] inputs = driver.getFieldIds();
        if (inputs.length == 0) {
            LOGGER.warn("VISREC: Got tree driver with no inputs");
        } else {
            driver.addVisRecommendations(this.recommender.tree(driver.getTargetId(), inputs));
        }
    }
}

