/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.lifecycle;

import org.apache.wink.common.annotations.Scope;
import org.apache.wink.common.internal.lifecycle.LifecycleManager;
import org.apache.wink.common.internal.lifecycle.LifecycleManagerUtils;
import org.apache.wink.common.internal.lifecycle.ObjectFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeLifecycleManager<T>
implements LifecycleManager<T> {
    @Override
    public ObjectFactory<T> createObjectFactory(T object) {
        if (object == null) {
            return null;
        }
        Class<?> cls = object.getClass();
        Scope scope = cls.getAnnotation(Scope.class);
        if (scope != null) {
            if (scope.value() == Scope.ScopeType.SINGLETON) {
                return LifecycleManagerUtils.createSingletonObjectFactory(object);
            }
            if (scope.value() == Scope.ScopeType.PROTOTYPE) {
                return LifecycleManagerUtils.createPrototypeObjectFactory(cls);
            }
        }
        return null;
    }

    @Override
    public ObjectFactory<T> createObjectFactory(Class<T> cls) {
        if (cls == null) {
            return null;
        }
        Scope scope = cls.getAnnotation(Scope.class);
        if (scope != null) {
            if (scope.value() == Scope.ScopeType.SINGLETON) {
                return LifecycleManagerUtils.createSingletonObjectFactory(cls);
            }
            if (scope.value() == Scope.ScopeType.PROTOTYPE) {
                return LifecycleManagerUtils.createPrototypeObjectFactory(cls);
            }
        }
        return null;
    }
}

