/*
 * Decompiled with CFR 0.152.
 */
package io.prestosql.jdbc.cognos.adaptor;

import com.ibm.cognos.jdbc.adaptor.AbstractPropertyLoader;
import com.ibm.cognos.jdbc.adaptor.AdaptorFactory;
import io.prestosql.jdbc.cognos.adaptor.PrestoConnectionAdaptor;
import io.prestosql.jdbc.cognos.adaptor.PrestoResultSetAdaptor;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;

public class PrestoDriverPrestoAdaptorFactory
extends AdaptorFactory {
    private static volatile AbstractPropertyLoader propertyLoader;
    private static final String IO = "io";
    private String serverType = "UNKNOWN";

    protected void setPropertyLoader(AbstractPropertyLoader loader) {
        propertyLoader = loader;
    }

    public AbstractPropertyLoader getPropertyLoader() {
        return propertyLoader;
    }

    protected void registerWrappers() {
        this.setConnectionWrapper(new PrestoConnectionAdaptor.Wrapper());
        this.setResultSetWrapper(new PrestoResultSetAdaptor.Wrapper());
    }

    public Connection connect(Driver driver, String url, Properties driverProperties, Properties ibmCognosProperties) throws SQLException {
        Connection connection = super.connect(driver, url, driverProperties, ibmCognosProperties);
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            metadata.getDatabaseProductVersion();
        }
        catch (SQLException ex) {
            SQLException exn = this.processSQLException(ex);
            throw exn;
        }
        return connection;
    }

    protected void determineSubType(Connection connection) throws SQLException {
        this.checkPrestoSubType(connection);
        if (this.serverType.equals(IO)) {
            this.setSubType(this.serverType);
        } else {
            super.determineSubType(connection);
        }
    }

    private void checkPrestoSubType(Connection connection) throws SQLException {
        try {
            DatabaseMetaData metadata = connection.getMetaData();
            String productName = metadata.getDatabaseProductName();
            if (productName.equals("Presto")) {
                this.serverType = IO;
            }
        }
        catch (SQLException ex) {
            SQLException exn = this.processSQLException(ex);
            throw exn;
        }
    }
}

