/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.ipf;

import com.cognos.cclcorej.util.CCLResourceCounterSet;
import com.cognos.indications.LogAuditAccessIndication;
import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLoggerLegacy;
import com.ibm.cognos.aurora.core.logging.AbstractLogger;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.LogAction;
import com.ibm.cognos.aurora.core.logging.LogEventHelper;
import com.ibm.cognos.aurora.core.logging.event.AuditLogBaseEvent;
import com.ibm.cognos.aurora.core.logging.event.AuditLogEvent;
import com.ibm.cognos.aurora.core.logging.event.BaseLogEvent;
import com.ibm.cognos.aurora.core.logging.event.PerfLogEvent;
import com.ibm.cognos.aurora.core.logging.event.TraceLogEvent;
import com.ibm.cognos.aurora.core.logging.ipf.IPFPerfLogEvent;
import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class IPFLogger
extends AbstractLogger
implements ILogger,
Serializable {
    private LogTypedLoggerLegacy traceLogger = null;
    private LogTypedLoggerLegacy auditLogger = null;
    private LogTypedLoggerLegacy perfLogger = null;
    private static final long serialVersionUID = -3383242948400195017L;

    protected Logger getTraceLogger() {
        return this.traceLogger;
    }

    protected void setTraceLogger(LogTypedLoggerLegacy traceLogger) {
        this.traceLogger = traceLogger;
    }

    protected Logger getAuditLogger() {
        return this.auditLogger;
    }

    protected void setAuditLogger(LogTypedLoggerLegacy auditLogger) {
        this.auditLogger = auditLogger;
    }

    protected Logger getPerfLogger() {
        return this.perfLogger;
    }

    protected void setPerfLogger(LogTypedLoggerLegacy perfLogger) {
        this.perfLogger = perfLogger;
    }

    public void auditSystemEvent(AuditLogEvent event) {
        if (this.isAuditSystemEventEnabled() && event != null) {
            this.auditLogger.log((Object)this.createAuditAccessIndication(event, 50000));
        }
    }

    public void auditRequestEvent(AuditLogEvent event) {
        if (this.isAuditRequestEventEnabled() && event != null) {
            this.auditLogger.log((Object)this.createAuditAccessIndication(event, 30000));
        }
    }

    public void auditInfoEvent(AuditLogBaseEvent event) {
        if (this.isAuditInfoEventEnabled() && event != null) {
            this.auditLogger.log((Object)this.createAuditIndication(event, 20000));
        }
    }

    public void auditDebugEvent(AuditLogBaseEvent event) {
        if (this.isAuditDebugEventEnabled() && event != null) {
            this.auditLogger.log((Object)this.createAuditIndication(event, 10000));
        }
    }

    public void fatal(AuditLogEvent event) {
        this.auditSystemEvent(event);
        if (this.isFatalEnabled() && event != null) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((AuditLogEvent)event, (Level)Level.FATAL), 50000));
        }
    }

    public void fatal(String errorMessage, String tracedObject) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error((String)errorMessage, (String)tracedObject));
        if (this.isFatalEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)errorMessage, (String)tracedObject, (Level)Level.FATAL), 50000));
        }
    }

    public void fatal(String errorMessage, String tracedObject, Throwable t) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error((String)errorMessage, (String)tracedObject, (Throwable)t));
        if (this.isFatalEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)errorMessage, (String)tracedObject, (Throwable)t, (Level)Level.FATAL), 50000));
        }
    }

    public void error(AuditLogEvent event) {
        this.auditSystemEvent(event);
        if (this.isErrorEnabled() && event != null) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((AuditLogEvent)event, (Level)Level.ERROR), 40000));
        }
    }

    public void error(String errorMessage, String tracedObject) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error((String)errorMessage, (String)tracedObject));
        if (this.isErrorEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)errorMessage, (String)tracedObject, (Level)Level.ERROR), 40000));
        }
    }

    public void error(String errorMessage, String tracedObject, Throwable t) {
        this.auditSystemEvent(LogEventHelper.createAuditLogEvent4Error((String)errorMessage, (String)tracedObject, (Throwable)t));
        if (this.isErrorEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)errorMessage, (String)tracedObject, (Throwable)t, (Level)Level.ERROR), 40000));
        }
    }

    public void warn(String message, String tracedObject) {
        if (this.isWarnEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)message, (String)tracedObject, (Level)Level.WARN), 30000));
        }
    }

    public void warn(String message, String tracedObject, Throwable t) {
        if (this.isWarnEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)message, (String)tracedObject, (Throwable)t, (Level)Level.WARN), 30000));
        }
    }

    public void info(String message, String tracedObject) {
        if (this.isInfoEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)message, (String)tracedObject, (Level)Level.INFO), 20000));
        }
    }

    public void info(String message, String tracedObject, Throwable t) {
        if (this.isInfoEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)message, (String)tracedObject, (Throwable)t, (Level)Level.INFO), 20000));
        }
    }

    public void debug(String message, String tracedObject) {
        if (this.isDebugEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)message, (String)tracedObject, (Level)Level.DEBUG), 10000));
        }
    }

    public void debug(String message, String tracedObject, Throwable t) {
        if (this.isDebugEnabled()) {
            this.traceLogger.log((Object)this.createTraceIndication(LogEventHelper.createTraceLogEvent((String)message, (String)tracedObject, (Throwable)t, (Level)Level.DEBUG), 10000));
        }
    }

    private LogTraceIndication createTraceIndication(TraceLogEvent event, int level) {
        if (event == null) {
            return null;
        }
        LogTraceIndication tind = new LogTraceIndication("ATHENA", 5000);
        tind.setLevel(level);
        this.setBaseIndications((BaseLogEvent)event, level, (LogIndication)tind);
        tind.setMessage(event.getMessage());
        tind.setObject(event.getTracedObject());
        tind.setAction((byte)11);
        return tind;
    }

    private LogAuditAccessIndication createAuditAccessIndication(AuditLogEvent event, int level) {
        if (event == null) {
            return null;
        }
        LogAuditAccessIndication aind = new LogAuditAccessIndication("ATHENA", 5000);
        this.setBaseIndications((BaseLogEvent)event, level, (LogIndication)aind);
        this.setBaseAuditIndications((AuditLogBaseEvent)event, (LogAuditIndication)aind);
        aind.setObjectPath(event.getObjectPath());
        aind.setObjectType(event.getObjectType().getName());
        aind.setStatus(event.getStatus().getName());
        aind.setErrorMessage(event.getMessage());
        return aind;
    }

    private void setBaseIndications(BaseLogEvent event, int level, LogIndication aind) {
        aind.setLevel(level);
        aind.setSessionID(event.getSessionID());
        aind.setRequestID(event.getRequestID());
        aind.setSubRequestID(event.getSubRequestID());
    }

    private LogAuditIndication createAuditIndication(AuditLogBaseEvent event, int level) {
        if (event == null) {
            return null;
        }
        LogAuditIndication aind = new LogAuditIndication("ATHENA", 5000);
        this.setBaseIndications((BaseLogEvent)event, level, (LogIndication)aind);
        this.setBaseAuditIndications(event, aind);
        return aind;
    }

    private void setBaseAuditIndications(AuditLogBaseEvent event, LogAuditIndication aind) {
        aind.setOperation(event.getOperation().getName());
        aind.setLogData(event.getLogData().toString());
    }

    public PerfLogEvent startPerfDebug(String className, String methodName, String startMessage) {
        return this.startPerfDebug(className, methodName, startMessage, LogAction.START);
    }

    public PerfLogEvent startPerfDebug(String className, String methodName, String startMessage, LogAction action) {
        if (this.isPerfDebugEnabled()) {
            CCLResourceCounterSet rcs = new CCLResourceCounterSet(this.getPerfLogger().getName(), null);
            IPFPerfLogEvent event = new IPFPerfLogEvent(className, methodName, rcs);
            event.enableResourceCounter();
            LogPerfIndication perfInd = new LogPerfIndication("ATHENA", 5000, rcs);
            perfInd.setLevel(10000);
            perfInd.setClassId(className);
            perfInd.setMethodId(methodName);
            perfInd.setLogData(startMessage);
            perfInd.setStatus(action.name());
            this.perfLogger.log((Object)perfInd);
            event.setPerfIndication(perfInd);
            return event;
        }
        return null;
    }

    public void stopPerfDebug(PerfLogEvent perfLogEvent, String stopMessage) {
        this.stopPerfDebug(perfLogEvent, stopMessage, LogAction.FINISH);
    }

    public void stopPerfDebug(PerfLogEvent perfLogEvent, String stopMessage, LogAction action) {
        if (perfLogEvent == null) {
            return;
        }
        if (this.isPerfDebugEnabled() && perfLogEvent.isIPFPerfLogEvent()) {
            IPFPerfLogEvent ipfRCS = (IPFPerfLogEvent)perfLogEvent;
            ipfRCS.disableResourceCounter();
            LogPerfIndication perfInd = ipfRCS.getPerfIndication();
            if (perfInd != null) {
                perfInd.setLogData(stopMessage);
                perfInd.setStatus(action.name());
                this.perfLogger.log((Object)perfInd);
            }
        }
    }
}

