/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.aurora.core.logging.ipf;

import com.cognos.indications.LogAuditIndication;
import com.cognos.indications.LogPerfIndication;
import com.cognos.indications.LogTraceIndication;
import com.cognos.indications.LogTypedLoggerLegacy;
import com.ibm.cognos.aurora.core.logging.ILogger;
import com.ibm.cognos.aurora.core.logging.ILoggerFactory;
import com.ibm.cognos.aurora.core.logging.ipf.IPFLogger;
import org.apache.log4j.Level;

public class IPFLoggerFactory
implements ILoggerFactory {
    public IPFLoggerFactory() throws ClassNotFoundException {
        if (this.isInitializable()) {
            this.setDefaultRootCategories();
        }
    }

    private void setDefaultRootCategories() {
        LogTypedLoggerLegacy auditRootLogger = LogTypedLoggerLegacy.getInstance((String)"Audit.RTUsage", LogAuditIndication.class);
        this.setLevelOffIfNull(auditRootLogger);
        LogTypedLoggerLegacy traceLogger = LogTypedLoggerLegacy.getInstance((String)"Trace", LogTraceIndication.class);
        this.setLevelOffIfNull(traceLogger);
        LogTypedLoggerLegacy perfLogger = LogTypedLoggerLegacy.getInstance((String)"Perf", LogPerfIndication.class);
        this.setLevelOffIfNull(perfLogger);
    }

    public void setLevelOffIfNull(LogTypedLoggerLegacy logger) {
        if (logger.getLevel() == null) {
            logger.setLevel(Level.OFF);
        }
    }

    public ILogger makeNewLoggerInstance(String categoryName) {
        IPFLogger ipfLogger = new IPFLogger();
        LogTypedLoggerLegacy auditLogger = LogTypedLoggerLegacy.getInstance((String)("Audit.RTUsage." + categoryName), LogAuditIndication.class);
        ipfLogger.setAuditLogger(auditLogger);
        LogTypedLoggerLegacy traceLogger = LogTypedLoggerLegacy.getInstance((String)("Trace." + categoryName), LogTraceIndication.class);
        ipfLogger.setTraceLogger(traceLogger);
        LogTypedLoggerLegacy perfLogger = LogTypedLoggerLegacy.getInstance((String)("Perf." + categoryName), LogPerfIndication.class);
        ipfLogger.setPerfLogger(perfLogger);
        return ipfLogger;
    }

    public boolean isInitializable() throws ClassNotFoundException {
        try {
            Class<?> newClass = Class.forName(LogTypedLoggerLegacy.class.getName());
            return newClass != null;
        }
        catch (ClassNotFoundException ex) {
            System.out.println(ex.getLocalizedMessage() + " IPF Logger is not initializable. ");
            throw ex;
        }
    }
}

