/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.data;

public class Range {
    private final double min;
    private final double max;

    public Range(double a, double b) {
        this.min = Math.min(a, b);
        this.max = Math.max(a, b);
        if (Double.isNaN(b) || Double.isNaN(a)) {
            throw new IllegalArgumentException("NaN values are not allowed");
        }
    }

    public double mid() {
        return (this.min + this.max) / 2.0;
    }

    public double maxExclusive() {
        return this.max;
    }

    public double minInclusive() {
        return this.min;
    }

    public double range() {
        return this.max - this.min;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Range range = (Range)o;
        return Double.compare(range.min, this.min) == 0 && Double.compare(range.max, this.max) == 0;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.min);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "[" + this.min + ", " + this.max + ')';
    }

    public boolean contains(double v) {
        return v >= this.min && v < this.max;
    }

    public static Range union(Range a, Range b) {
        return new Range(Math.min(a.min, b.min), Math.max(a.max, b.max));
    }
}

