/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.dataaccess.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

public enum AggregationType {
    COUNT("count"),
    COUNT_DISTINCT("countdistinct"),
    SUM("sum"),
    AVERAGE("avg"),
    MINIMUM("min"),
    MAXIMUM("max"),
    NONE(null),
    UNKNOWN("UNKNOWN");

    private String aggregation;

    private AggregationType(String aggregation) {
        this.aggregation = aggregation;
    }

    @JsonValue
    public String toString() {
        return this.aggregation;
    }

    @JsonCreator
    public static AggregationType fromString(String aggregation) {
        if (AggregationType.isNone(aggregation)) {
            return NONE;
        }
        for (AggregationType agg : AggregationType.values()) {
            if (!aggregation.equalsIgnoreCase(agg.aggregation)) continue;
            return agg;
        }
        return UNKNOWN;
    }

    private static boolean isNone(String aggregation) {
        return aggregation == null || "none".equals(aggregation);
    }

    public static boolean isNone(AggregationType agg) {
        return agg == null || agg == NONE;
    }
}

