/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.util;

import java.util.Arrays;
import java.util.function.IntConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class IntList
implements Comparable<IntList> {
    private static final int MAX_TO_STRING_ITEMS = 20;
    private int[] content;
    private int n;

    public static IntList wrapping(int ... values) {
        return new IntList(values);
    }

    public IntList() {
        this(16);
    }

    public IntList(int n) {
        this.content = new int[n];
    }

    private IntList(int[] rows) {
        this.content = rows;
        this.n = rows.length;
    }

    public IntList addAll(IntList other) {
        if (this.n + other.n > this.content.length) {
            this.content = Arrays.copyOf(this.content, this.n + other.n);
        }
        System.arraycopy(other.content, 0, this.content, this.n, other.n);
        this.n += other.n;
        return this;
    }

    @Override
    public int compareTo(IntList o) {
        int common = Math.min(this.n, o.n);
        for (int i = 0; i < common; ++i) {
            int d = this.content[i] - o.content[i];
            if (d == 0) continue;
            return d;
        }
        return this.n - o.n;
    }

    public final int len() {
        return this.n;
    }

    public void clear() {
        this.n = 0;
    }

    public final int value(int i) {
        return this.content[i];
    }

    int storeSize() {
        return this.content.length;
    }

    public IntList add(int v) {
        if (this.n + 1 > this.content.length) {
            this.content = Arrays.copyOf(this.content, Math.max(4, this.content.length * 2));
        }
        this.content[this.n++] = v;
        return this;
    }

    public void forEach(IntConsumer consumer) {
        for (int i = 0; i < this.n; ++i) {
            consumer.accept(this.content[i]);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntList intList = (IntList)o;
        if (this.n != intList.n) {
            return false;
        }
        return this.compareTo(intList) == 0;
    }

    public IntStream stream() {
        return Arrays.stream(this.content).limit(this.n);
    }

    public int hashCode() {
        int result = this.n;
        for (int i = 0; i < this.n; ++i) {
            result = 31 * result + this.content[i];
        }
        return result;
    }

    public String toString() {
        if (this.n <= 20) {
            return "[" + Arrays.stream(this.content).limit(this.n).mapToObj(Integer::toString).collect(Collectors.joining(", ")) + "]";
        }
        return "[" + Arrays.stream(this.content).limit(19L).mapToObj(Integer::toString).collect(Collectors.joining(", ")) + ", ..., " + Integer.toString(this.content[this.n - 1]) + "]";
    }
}

