/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.fastpattern.util;

import com.ibm.bi.predict.fastpattern.util.IntList;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.lang.ref.SoftReference;
import java.util.Stack;

public class IntListPool {
    private static final Logger LOG = PredictLoggerFactory.getLogger(IntListPool.class);
    private final Stack<SoftReference<IntList>> pool = new Stack();

    public synchronized IntList get(int desiredSize) {
        while (!this.pool.empty()) {
            SoftReference<IntList> pop = this.pool.pop();
            IntList list = pop.get();
            if (list == null) continue;
            LOG.trace(() -> "Pool contained a valid item, pool count = " + this.pool.size());
            list.clear();
            return list;
        }
        LOG.trace(() -> "Pool did not contain a usable item");
        return new IntList(desiredSize);
    }

    public void releaseToPool(IntList list) {
        if (list != null) {
            this.pool.add(new SoftReference<IntList>(list));
            LOG.trace(() -> "Adding list of size " + list.storeSize() + " to pool, pool count = " + this.pool.size());
        }
    }

    public int size() {
        return this.pool.size();
    }
}

