/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.messages;

import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.messages.UTF8ResourceBundleControl;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;

public class Messages {
    private static Map<String, Messages> messagesByBundleLocale = new HashMap<String, Messages>();
    private static Map<String, ResourceBundle> englishBundleMap = new HashMap<String, ResourceBundle>();
    private static final String ENGLISH_MARKER = "[EN] ";
    private final String bundleName;
    private final ResourceBundle bundle;
    private final NumberFormat numberFormat;
    private final Locale locale;

    Messages(String bundleName, Locale locale) {
        try {
            this.bundle = ResourceBundle.getBundle(bundleName, locale, new UTF8ResourceBundleControl());
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Could not find resource bundle '" + bundleName + "'", e);
        }
        this.bundleName = bundleName;
        this.locale = locale;
        this.numberFormat = NumberFormat.getInstance(locale);
    }

    public String get(String key, Object ... parameters) {
        ResourceBundle useBundle = this.bundle;
        String baseBundleName = this.bundle.getBaseBundleName();
        try {
            if (!this.bundle.containsKey(key)) {
                useBundle = this.getEnglishBundle(baseBundleName);
            }
            String template = useBundle.getString(key);
            if (!useBundle.equals(this.bundle)) {
                template = ENGLISH_MARKER + template;
            }
            String string = this.applyParametersToTemplate(key, template, parameters);
            return string;
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Could not find key '" + key + "' in bundle '" + useBundle.toString() + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getEnglishBundle(String bundleBaseName) {
        if (englishBundleMap.containsKey(bundleBaseName)) {
            return englishBundleMap.get(bundleBaseName);
        }
        Map<String, ResourceBundle> map = englishBundleMap;
        synchronized (map) {
            ResourceBundle englishBundle = ResourceBundle.getBundle(bundleBaseName, Locale.ENGLISH, new UTF8ResourceBundleControl());
            englishBundleMap.put(bundleBaseName, englishBundle);
            return englishBundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Messages getMessagesFor(String bundleName, Locale locale) {
        Messages messages;
        String key = bundleName + "###" + locale.toString();
        Map<String, Messages> map = messagesByBundleLocale;
        synchronized (map) {
            messages = messagesByBundleLocale.computeIfAbsent(key, k -> new Messages(bundleName, locale));
        }
        return messages;
    }

    private String applyParametersToTemplate(String key, String template, Object[] arguments) {
        MessageFormat fmt = new MessageFormat(template);
        int nFormats = fmt.getFormatsByArgumentIndex().length;
        if (nFormats < arguments.length) {
            throw new IllegalArgumentException(this.bundleName + " " + key + ": too many parameters passed in.");
        }
        if (nFormats > arguments.length) {
            throw new IllegalArgumentException(this.bundleName + " " + key + ": too few parameters passed in.");
        }
        A[] formattedArgs = Arrays.stream(arguments).map(this::format).toArray(Object[]::new);
        return fmt.format(formattedArgs);
    }

    private String format(Object p) {
        if (p instanceof Number) {
            if (p instanceof Double) {
                return NumberFormatter.format(this.locale, true, (Double)p);
            }
            return this.numberFormat.format(p);
        }
        return Objects.toString(p);
    }

    protected ResourceBundle getBundle() {
        return this.bundle;
    }
}

