/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.messages;

import com.ibm.bi.predict.messages.UTF8ResourceBundleControl;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MessagesProvider {
    public static final String RAW = "RAW";
    public static final String NLT = "NLT";
    private static final String ENGLISH_MARKER = "[EN] ";
    private static Pattern spanPattern = Pattern.compile("<span class=\\\"[^\"]*\\\">(?<group>.+?)<\\/span>");
    private static Map<String, MessagesProvider> providerMap = new HashMap<String, MessagesProvider>();
    private static Map<String, ResourceBundle> bundlesMap = new HashMap<String, ResourceBundle>();
    private final String bundleName;
    private final Locale locale;
    private final ResourceBundle bundle;
    private final ResourceBundle englishBundle;
    private final NumberFormat numberFormat;
    private final NumberFormat percentFormat;
    private final boolean replaceHtmlEntities;
    private final boolean removeSpanTags;

    private MessagesProvider(String bundleName, Locale locale) {
        try {
            this.bundle = this.getBundle(bundleName, locale);
            this.englishBundle = this.getBundle(bundleName, Locale.ENGLISH);
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Could not find resource bundle '" + bundleName + "'", e);
        }
        this.bundleName = bundleName;
        this.locale = locale;
        this.numberFormat = NumberFormat.getInstance(locale);
        this.percentFormat = NumberFormat.getPercentInstance(locale);
        this.percentFormat.setMaximumFractionDigits(1);
        boolean isRAW = RAW.equals(locale.getVariant());
        boolean isNLT = NLT.equals(locale.getVariant());
        this.replaceHtmlEntities = !isRAW;
        this.removeSpanTags = !isRAW && !isNLT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(String bundleName, Locale locale) {
        Map<String, ResourceBundle> map = bundlesMap;
        synchronized (map) {
            String key = bundleName + "###" + locale.getLanguage() + "_" + locale.getCountry();
            return bundlesMap.computeIfAbsent(key, k -> this.loadBundle(bundleName, locale));
        }
    }

    protected ResourceBundle loadBundle(String bundleName, Locale locale) {
        return ResourceBundle.getBundle(bundleName, locale, new UTF8ResourceBundleControl());
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String get(String key, Object ... parameters) {
        ResourceBundle useBundle = this.bundle;
        try {
            if (!this.bundle.containsKey(key)) {
                useBundle = this.englishBundle;
            }
            String template = useBundle.getString(key);
            if (!useBundle.equals(this.bundle)) {
                template = ENGLISH_MARKER + template;
            }
            String string = this.applyParametersToTemplate(key, template, parameters);
            if (this.removeSpanTags) {
                string = MessagesProvider.removeSpans(string);
            }
            return string;
        }
        catch (MissingResourceException e) {
            throw new IllegalArgumentException("Could not find key '" + key + "' in bundle '" + this.bundleName + "'", e);
        }
    }

    private static String removeSpans(String str) {
        Matcher matcher = spanPattern.matcher(str);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1));
        }
        matcher.appendTail(stringBuffer);
        return stringBuffer.toString();
    }

    public String getSuffix(String key, String suffix, Object ... parameters) {
        return this.get(key + "_" + suffix, parameters);
    }

    public String getList(String key, List<? extends Object> list, Object ... parameters) {
        int i;
        String messageKey;
        int listArgsUsed;
        int maxListArgs;
        int listLength = list.size();
        if (listLength > (maxListArgs = Integer.parseInt(this.getConstant(key + "_MAXARGS")))) {
            listArgsUsed = maxListArgs;
            messageKey = key + "_ANDOTHERS";
        } else {
            listArgsUsed = listLength;
            messageKey = key + "_" + listLength;
        }
        Object[] newArgs = new Object[parameters.length + listArgsUsed];
        for (i = 0; i < parameters.length; ++i) {
            newArgs[i] = parameters[i];
        }
        for (i = 0; i < listArgsUsed; ++i) {
            newArgs[i + parameters.length] = list.get(i);
        }
        return this.get(messageKey, newArgs);
    }

    public String getSuffixList(String key, String suffix, List<? extends Object> list, Object ... parameters) {
        return this.getList(key + "_" + suffix, list, parameters);
    }

    private String applyParametersToTemplate(String key, String template, Object[] arguments) {
        MessageFormat fmt = new MessageFormat(template);
        int nFormats = fmt.getFormatsByArgumentIndex().length;
        if (nFormats < arguments.length) {
            throw new IllegalArgumentException(this.bundleName + " " + key + ": too many parameters passed in.");
        }
        if (nFormats > arguments.length) {
            throw new IllegalArgumentException(this.bundleName + " " + key + ": too few parameters passed in.");
        }
        A[] formattedArgs = Arrays.stream(arguments).map(this::format).toArray(Object[]::new);
        return fmt.format(formattedArgs);
    }

    private String format(Object p) {
        if (p instanceof Percentage) {
            return this.percentFormat.format(((Percentage)p).value);
        }
        if (p instanceof Number) {
            return this.numberFormat.format(p);
        }
        String s = Objects.toString(p);
        if (this.replaceHtmlEntities) {
            return s.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        }
        return s;
    }

    public String getConstant(String key) {
        return this.get(key, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MessagesProvider getMessagesFor(String bundleName, Locale locale) {
        String key = bundleName + "###" + locale.toString();
        Map<String, MessagesProvider> map = providerMap;
        synchronized (map) {
            return providerMap.computeIfAbsent(key, k -> new MessagesProvider(bundleName, locale));
        }
    }

    public static Locale rawVariant(Locale locale) {
        return new Locale(locale.getLanguage(), locale.getCountry(), RAW);
    }

    public static Locale nltVariant(Locale locale) {
        return new Locale(locale.getLanguage(), locale.getCountry(), NLT);
    }

    public static class Percentage {
        final double value;

        public Percentage(double value) {
            this.value = value;
        }
    }
}

