/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.messages;

import com.ibm.bi.predict.exceptions.BadParametersException;
import com.ibm.bi.predict.math.NumberFormatter;
import com.ibm.bi.predict.messages.Messages;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class PredictiveStrengthMessageProvider {
    private Messages messageSource;
    private Map<String, String> messageIds = new HashMap<String, String>();
    private Locale locale;

    public PredictiveStrengthMessageProvider(String bundleName, Locale locale) {
        this.locale = locale;
        this.messageSource = Messages.getMessagesFor(bundleName, locale);
        this.loadIds();
    }

    public String getMessage(Object ... parameters) {
        String key = this.computeKey(parameters);
        return this.messageSource.get(key, this.cleanupParameters(parameters));
    }

    public String getId() {
        return "PREDICTIVE_STRENGTH";
    }

    public String getCaption() {
        return this.messageSource.get(this.messageIds.get("CAPTION"), new Object[0]);
    }

    private String computeKey(Object ... parameters) {
        int lastParam = parameters.length - 1;
        double strength = lastParam >= 0 ? (Double)parameters[lastParam] : 0.0;
        switch (parameters.length) {
            case 0: {
                return this.messageIds.get("NONE-0");
            }
            case 1: {
                return this.messageIds.get("SHORT");
            }
            case 2: {
                throw new BadParametersException("Incorrect number of parameters");
            }
            case 3: {
                return this.messageForStrength(1, strength);
            }
            case 4: {
                return this.messageForStrength(2, strength);
            }
            case 5: {
                return this.messageForStrength(3, strength);
            }
        }
        return this.messageForStrength(4, strength);
    }

    private void loadIds() {
        this.messageIds.put("NONE-0", "PREDICTIVE_STRENGTH_LONG_NO_RESULTS_GENERAL");
        this.messageIds.put("LOW-1", "PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_LOW");
        this.messageIds.put("LOW-2", "PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_LOW");
        this.messageIds.put("LOW-3", "PREDICTIVE_STRENGTH_DECO_LONG_THREE_FACTOR_LOW");
        this.messageIds.put("LOW-4", "PREDICTIVE_STRENGTH_DECO_LONG_MULTIPLE_FACTOR_LOW");
        this.messageIds.put("MED-1", "PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_MEDIUM");
        this.messageIds.put("MED-2", "PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_MEDIUM");
        this.messageIds.put("MED-3", "PREDICTIVE_STRENGTH_DECO_LONG_THREE_FACTOR_MEDIUM");
        this.messageIds.put("MED-4", "PREDICTIVE_STRENGTH_DECO_LONG_MULTIPLE_FACTOR_MEDIUM");
        this.messageIds.put("HIGH-1", "PREDICTIVE_STRENGTH_DECO_LONG_SINGLE_FACTOR_HIGH");
        this.messageIds.put("HIGH-2", "PREDICTIVE_STRENGTH_DECO_LONG_TWO_FACTOR_HIGH");
        this.messageIds.put("HIGH-3", "PREDICTIVE_STRENGTH_DECO_LONG_THREE_FACTOR_HIGH");
        this.messageIds.put("HIGH-4", "PREDICTIVE_STRENGTH_DECO_LONG_MULTIPLE_FACTOR_HIGH");
        this.messageIds.put("SHORT", "PREDICTIVE_STRENGTH_SHORT");
        this.messageIds.put("CAPTION", "PREDICTIVE_STRENGTH");
    }

    private String messageForStrength(int numberOfFields, double strength) {
        return this.messageIds.get(this.getStrengthWord(strength) + "-" + numberOfFields);
    }

    private String getStrengthWord(double strength) {
        String strengthWord = strength < 0.35 ? "LOW" : (strength >= 0.35 && strength < 0.7 ? "MED" : "HIGH");
        return strengthWord;
    }

    private Object[] cleanupParameters(Object[] parameters) {
        if (parameters.length == 0) {
            return parameters;
        }
        Double accuracy = (Double)parameters[parameters.length - 1];
        String accuracyStr = this.getAccuracyPercent(accuracy);
        if (parameters.length <= 5) {
            parameters[parameters.length - 1] = accuracyStr;
            return parameters;
        }
        Object[] trimmedParams = new Object[]{parameters[0], parameters[1], parameters.length - 4, parameters[parameters.length - 2], accuracyStr};
        return trimmedParams;
    }

    private String getAccuracyPercent(double accuracy) {
        return NumberFormatter.percentFormat(this.locale, accuracy);
    }
}

