/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.messages;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;

public class UTF8ResourceBundleControl
extends ResourceBundle.Control {
    private static String PROPERTIES = "properties";

    @Override
    public List<String> getFormats(String baseName) {
        return Collections.singletonList(PROPERTIES);
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IOException {
        this.checkNullInputs(baseName, locale, format, loader);
        if (!format.equals(PROPERTIES)) {
            return null;
        }
        String bundleName = this.toBundleName(baseName, locale);
        String resourceName = this.toResourceName(bundleName, format);
        InputStream stream = loader.getResourceAsStream(resourceName);
        InputStreamReader reader = new InputStreamReader(stream, "UTF-8");
        return new PropertyResourceBundle(reader);
    }

    private void checkNullInputs(String baseName, Locale locale, String format, ClassLoader loader) {
        if (baseName == null || locale == null || format == null || loader == null) {
            throw new NullPointerException("Null object in newBundle(...) call");
        }
    }
}

