/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.result;

import com.ibm.bi.predict.result.Message;
import com.ibm.bi.predict.result.StatusCode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ExecutionResult<T> {
    private final StatusCode status;
    private final T content;
    private final List<Message> errorMessages;
    private final List<Message> warningMessages;
    private final List<String> diagnosticMessages;

    public ExecutionResult(StatusCode status, T content) {
        this.status = status;
        this.content = content;
        this.errorMessages = new ArrayList<Message>();
        this.warningMessages = new ArrayList<Message>();
        this.diagnosticMessages = new ArrayList<String>();
    }

    public StatusCode getStatus() {
        return this.status;
    }

    public List<Message> getErrorMessages() {
        return this.errorMessages;
    }

    public List<Message> getWarningMessages() {
        return this.warningMessages;
    }

    public List<String> getDiagnosticMessages() {
        return this.diagnosticMessages;
    }

    public ExecutionResult<T> addErrorMessage(Message message) {
        this.errorMessages.add(message);
        return this;
    }

    public ExecutionResult<T> addWarningMessage(Message message) {
        this.warningMessages.add(message);
        return this;
    }

    public ExecutionResult<T> addDiagnosticMessage(String message) {
        this.diagnosticMessages.add(message);
        return this;
    }

    public ExecutionResult<T> addErrorMessages(Collection<Message> messages) {
        this.errorMessages.addAll(messages);
        return this;
    }

    public ExecutionResult<T> addWarningMessages(Collection<Message> messages) {
        this.warningMessages.addAll(messages);
        return this;
    }

    public ExecutionResult<T> addDiagnosticMessages(Collection<String> messages) {
        this.diagnosticMessages.addAll(messages);
        return this;
    }

    public ExecutionResult<T> addMessages(ExecutionResult<?> other) {
        this.warningMessages.addAll(other.warningMessages);
        this.errorMessages.addAll(other.errorMessages);
        this.diagnosticMessages.addAll(other.diagnosticMessages);
        return this;
    }

    public T getContent() {
        return this.content;
    }
}

