/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.result;

import com.ibm.bi.predict.messages.Messages;
import com.ibm.bi.predict.result.MessageCode;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class Message {
    private final MessageCode messageCode;
    private final Messages messages;
    private final Object[] parameters;
    private final List<String> columnIds;

    public static Message fromCode(MessageCode messageCode, Locale locale) {
        return new Message(messageCode, locale);
    }

    public Message(MessageCode messageCode, List<String> columnIds, Locale locale, Object ... parameters) {
        this.messageCode = messageCode;
        this.columnIds = columnIds;
        this.parameters = parameters;
        this.messages = Messages.getMessagesFor("Predict_Messages", locale);
    }

    public Message(MessageCode messageCode, Locale locale) {
        this(messageCode, Collections.emptyList(), locale, new Object[0]);
    }

    public Message(MessageCode messageCode, Locale locale, Object ... parameters) {
        this(messageCode, Collections.emptyList(), locale, parameters);
    }

    public MessageCode getMessageCode() {
        return this.messageCode;
    }

    public String getCaption() {
        return this.messages.get(this.messageCode.name(), this.parameters);
    }

    public List<String> getColumnIds() {
        return this.columnIds;
    }
}

