/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.result;

import com.ibm.bi.predict.result.Version;
import com.ibm.bi.predict.result.VersionRange;

public class VersionRanges {
    private final VersionRange previous;
    private final VersionRange latest;

    public VersionRanges(VersionRange prevRange, Version latestMin) {
        this.previous = prevRange;
        this.latest = new VersionRange(latestMin, this.predictVersion());
    }

    public boolean isSupported(Version version) {
        return version.compareTo(this.previous.min()) >= 0;
    }

    public Version previousMin() {
        return this.previous.min();
    }

    public Version previousMax() {
        return this.previous.max();
    }

    public boolean previousIncludes(Version version) {
        return version.compareTo(this.previous.min()) >= 0 && version.compareTo(this.latest.min()) < 0;
    }

    public Version latestMin() {
        return this.latest.min();
    }

    public Version latestMax() {
        return this.latest.max();
    }

    public boolean latestIncludes(Version version) {
        return version.compareTo(this.latest.max()) >= 0;
    }

    protected Version predictVersion() {
        return Version.LATEST;
    }
}

