/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.ibm.bi.predict.testharness.OutputWriter;
import com.ibm.bi.predict.testharness.TaskParameters;
import com.ibm.bi.predict.testharness.TaskResult;
import com.ibm.bi.predict.testharness.User;
import com.ibm.bi.predict.utils.EnvironmentInfo;
import com.ibm.bi.predict.utils.Logger;
import com.ibm.bi.predict.utils.PredictLoggerFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class Harness {
    private static final Logger logger = PredictLoggerFactory.getLogger(Harness.class);
    private static final int MAX_MILLIS_TO_WAIT_FOR_USER_COMPLETION = (int)TimeUnit.HOURS.toMillis(1L);
    private final ExecutorService executorService;
    private final OutputWriter outputWriter;
    private final List<List<User>> steps = new ArrayList<List<User>>();
    private int totalTasks;
    private Map<String, Integer> threadIndex;
    private int numCompleted;
    private int numFailures;
    private long overallStart;
    private EnvironmentInfo environment;
    private StatsDetail detail = StatsDetail.medium;

    public Harness(String name, Path outputPath) {
        this.executorService = Executors.newCachedThreadPool();
        this.outputWriter = new OutputWriter(name, outputPath);
        this.validatePath(outputPath);
    }

    public Harness(String name, Path outputPath, int numThreads) {
        this.executorService = Executors.newFixedThreadPool(numThreads);
        this.outputWriter = new OutputWriter(name, outputPath);
        this.validatePath(outputPath);
    }

    public Harness addStep(User user, int numUsers) {
        List<User> users = Collections.nCopies(numUsers, user);
        this.steps.add(users);
        return this;
    }

    public Harness addUsers(User user, int numUsersToAdd) {
        List<User> users = Collections.nCopies(numUsersToAdd, user);
        if (this.steps.isEmpty()) {
            this.steps.add(users);
        } else {
            this.steps.set(0, Lists.newArrayList((Iterable)Iterables.concat((Iterable)this.steps.get(0), users)));
        }
        return this;
    }

    public Harness outputDetail(StatsDetail detail) {
        this.detail = detail;
        return this;
    }

    public void run() {
        this.totalTasks = this.totalNumberOfTasks();
        this.numCompleted = 0;
        this.numFailures = 0;
        this.threadIndex = new ConcurrentHashMap<String, Integer>();
        this.environment = new EnvironmentInfo();
        logger.info("Starting {} steps", this.steps.size());
        this.overallStart = System.currentTimeMillis();
        ArrayList<List<TaskResult>> userResults = new ArrayList<List<TaskResult>>();
        for (int i = 0; i < this.steps.size(); ++i) {
            List<User> users = this.steps.get(i);
            int numConcurrentUsers = users.size();
            List<Future<List<TaskResult>>> futures = this.startPerUserTasks(users);
            logger.info("Submitted tasks for step: {}", i + 1);
            List<List<TaskResult>> results = this.waitForUserTaskCompletion(futures);
            logger.info("Tasks completed for step: {}", i + 1);
            if (results == null) continue;
            results.forEach(list -> list.forEach(r -> r.parameters().content.put("numUsers", Integer.valueOf(numConcurrentUsers))));
            userResults.addAll(results);
        }
        logger.info("Tasks completed");
        this.environment.setEndStatus();
        this.reportResults(userResults);
        this.numFailures = (int)userResults.stream().flatMap(Collection::stream).filter(r -> r.state() != TaskResult.State.success).count();
    }

    public int numFailures() {
        return this.numFailures;
    }

    private void reportResults(List<List<TaskResult>> userResults) {
        int overallTimeInMillis = (int)(System.currentTimeMillis() - this.overallStart);
        this.outputWriter.write(userResults, overallTimeInMillis, this.detail, this.environment);
    }

    private List<List<TaskResult>> waitForUserTaskCompletion(List<Future<List<TaskResult>>> futures) {
        ArrayList<List<TaskResult>> userResults = new ArrayList<List<TaskResult>>();
        for (Future<List<TaskResult>> future : futures) {
            try {
                List<TaskResult> lists = future.get(MAX_MILLIS_TO_WAIT_FOR_USER_COMPLETION, TimeUnit.MILLISECONDS);
                userResults.add(lists);
            }
            catch (InterruptedException e) {
                logger.error("Unexpected interruption. Reason: " + e.getMessage(), e);
                return null;
            }
            catch (ExecutionException e) {
                logger.error("Exception should have been handled earlier. Reason: " + e.getMessage(), e);
                return null;
            }
            catch (TimeoutException e) {
                logger.warn("Timeout for user tasks", e);
                return null;
            }
            catch (Throwable e) {
                logger.warn("Caught unknown exception. Reason: " + e.getMessage(), e);
                return null;
            }
        }
        return userResults;
    }

    private List<Future<List<TaskResult>>> startPerUserTasks(List<User> users) {
        ArrayList<Future<List<TaskResult>>> futures = new ArrayList<Future<List<TaskResult>>>();
        for (User user : users) {
            Future<List> userFuture = this.executorService.submit(() -> this.performUserTasks(user));
            futures.add(userFuture);
        }
        return futures;
    }

    private List<TaskResult> performUserTasks(User user) {
        ArrayList<TaskResult> userResults = new ArrayList<TaskResult>();
        for (User.Task task : user.tasks()) {
            Function<TaskParameters, String> action = task.action;
            TaskParameters parameters = task.parameters;
            userResults.add(this.runSingleTask(action, parameters));
            this.reportCompletion();
        }
        return userResults;
    }

    private TaskResult runSingleTask(Function<TaskParameters, String> action, TaskParameters parameters) {
        int threadIdx = this.threadIndex.computeIfAbsent(Thread.currentThread().getName(), t -> this.threadIndex.size() + 1);
        long start = System.currentTimeMillis();
        try {
            String message = action.apply(parameters);
            return TaskResult.makeSuccess(start - this.overallStart, System.currentTimeMillis() - this.overallStart, threadIdx, parameters, message);
        }
        catch (Throwable e) {
            return TaskResult.makeError(start - this.overallStart, System.currentTimeMillis() - this.overallStart, threadIdx, parameters, e);
        }
    }

    private void reportCompletion() {
        int lastPercent = 100 * this.numCompleted / this.totalTasks;
        ++this.numCompleted;
        int currentPercent = 100 * this.numCompleted / this.totalTasks;
        if (currentPercent == lastPercent) {
            return;
        }
        int elapsed = (int)(System.currentTimeMillis() - this.overallStart);
        if (currentPercent % 10 == 0 || elapsed > 60000) {
            logger.info("Completed " + currentPercent + "% of tasks");
        }
    }

    private int totalNumberOfTasks() {
        return this.steps.stream().flatMap(Collection::stream).mapToInt(u -> u.tasks().size()).sum();
    }

    private void validatePath(Path outputPath) {
        if (!outputPath.toFile().exists()) {
            String message = "Output directory does not exist: " + outputPath.toAbsolutePath();
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!outputPath.toFile().isDirectory()) {
            String message = "Output directory is not a directory: " + outputPath.toAbsolutePath();
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
        if (!outputPath.toFile().canWrite()) {
            String message = "Output directory cannot be written to: " + outputPath.toAbsolutePath();
            logger.error(message);
            throw new IllegalArgumentException(message);
        }
    }

    public static enum StatsDetail {
        minimal,
        medium,
        all;

    }
}

