/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class TaskParameters
implements Comparable<TaskParameters> {
    public final Map<String, Comparable<?>> content = new LinkedHashMap();

    public TaskParameters(String[] names, Comparable<?> ... values) {
        for (int i = 0; i < names.length; ++i) {
            this.content.put(names[i], values[i]);
        }
    }

    public static TaskParameters makeSimple(String parameterName, String value) {
        return new TaskParameters(new String[]{parameterName}, new Comparable[]{value});
    }

    public static TaskParameters makeSimple(String parameterName, double value) {
        return new TaskParameters(new String[]{parameterName}, new Double[]{value});
    }

    public static TaskParameters makeSimple(String parameterName, int value) {
        return new TaskParameters(new String[]{parameterName}, new Integer[]{value});
    }

    public static TaskParameters empty() {
        return new TaskParameters(new String[0], new Comparable[0]);
    }

    public static TaskParameters withNames(String ... names) {
        Comparable[] nullValues = new Comparable[names.length];
        for (int i = 0; i < names.length; ++i) {
            nullValues[i] = null;
        }
        return new TaskParameters(names, nullValues);
    }

    public static TaskParameters withValues(String n1, Comparable<?> v1) {
        return new TaskParameters(new String[]{n1}, v1);
    }

    public static TaskParameters withValues(String n1, Comparable<?> v1, String n2, Comparable<?> v2) {
        return new TaskParameters(new String[]{n1, n2}, v1, v2);
    }

    public static TaskParameters withValues(String n1, Comparable<?> v1, String n2, Comparable<?> v2, String n3, Comparable<?> v3) {
        return new TaskParameters(new String[]{n1, n2, n3}, v1, v2, v3);
    }

    public String asCSV() {
        return this.content.entrySet().stream().map(Object::toString).collect(Collectors.joining(";"));
    }

    public String asString(String key) {
        Comparable<?> o = this.content.get(key);
        return o.toString();
    }

    public double asDouble(String key) {
        Comparable<?> o = this.content.get(key);
        if (o instanceof Number) {
            return ((Number)((Object)o)).doubleValue();
        }
        throw new IllegalArgumentException("No numeric parameter with key " + key);
    }

    public int asInt(String key) {
        Comparable<?> o = this.content.get(key);
        if (o instanceof Number) {
            return ((Number)((Object)o)).intValue();
        }
        throw new IllegalArgumentException("No numeric parameter with key " + key);
    }

    public TaskParameters andValues(Comparable<?> ... values) {
        String[] names = this.content.keySet().toArray(new String[0]);
        return new TaskParameters(names, values);
    }

    @Override
    public int compareTo(TaskParameters o) {
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(this.content.keySet());
        keys.addAll(o.content.keySet());
        for (String key : keys) {
            boolean inOther;
            boolean inMe = this.content.containsKey(key);
            if (inMe == (inOther = o.content.containsKey(key))) continue;
            return inMe ? -1 : 1;
        }
        for (String key : keys) {
            Class<?> otherClass;
            Comparable<?> inMe = this.content.get(key);
            Comparable<?> inOther = o.content.get(key);
            Class<?> myClass = inMe.getClass();
            if (myClass.equals(otherClass = inOther.getClass())) {
                int c = inMe.compareTo(inOther);
                if (c == 0) continue;
                return c;
            }
            return myClass.getCanonicalName().compareTo(otherClass.getCanonicalName());
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TaskParameters that = (TaskParameters)o;
        return this.content.equals(that.content);
    }

    public int hashCode() {
        return this.content.hashCode();
    }

    public String toString() {
        return this.content.toString();
    }
}

