/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.testharness;

import com.ibm.bi.predict.testharness.TaskParameters;

class TaskResult
implements Comparable<TaskResult> {
    private final State state;
    private final TaskParameters parameters;
    private final String message;
    private final Throwable error;
    private final long timeStart;
    private final long timeEnd;
    private final int threadIndex;

    public static State[] states() {
        return State.values();
    }

    @Override
    public int compareTo(TaskResult o) {
        if (this.timeStart != o.timeStart) {
            return (int)(this.timeStart - o.timeStart);
        }
        if (this.timeEnd != o.timeEnd) {
            return (int)(this.timeEnd - o.timeEnd);
        }
        return this.hashCode() - o.hashCode();
    }

    public int thread() {
        return this.threadIndex;
    }

    public static TaskResult makeSuccess(long startTime, long endTime, int threadIndex, TaskParameters parameters, String message) {
        return new TaskResult(State.success, parameters, startTime, endTime, threadIndex, message, null);
    }

    public static TaskResult makeError(long startTime, long endTime, int threadIndex, TaskParameters parameters, Throwable e) {
        if (e instanceof OutOfMemoryError) {
            return new TaskResult(State.oom, parameters, startTime, endTime, threadIndex, e.getMessage(), e);
        }
        return new TaskResult(State.exception, parameters, startTime, endTime, threadIndex, e.getMessage(), e);
    }

    private TaskResult(State state, TaskParameters parameters, long startTime, long endTime, int threadIndex, String message, Throwable error) {
        this.state = state;
        this.parameters = parameters;
        this.timeStart = startTime;
        this.timeEnd = endTime;
        this.threadIndex = threadIndex;
        this.message = message != null ? message : error.toString();
        this.error = error;
    }

    public double timeInSeconds() {
        return (double)(this.timeEnd - this.timeStart) / 1000.0;
    }

    public State state() {
        return this.state;
    }

    public Throwable error() {
        return this.error;
    }

    public double timeStart() {
        return (double)this.timeStart / 1000.0;
    }

    public double timeEnd() {
        return (double)this.timeEnd / 1000.0;
    }

    public double totalTime() {
        return this.timeEnd() - this.timeStart();
    }

    public String message() {
        return this.message;
    }

    public TaskParameters parameters() {
        return this.parameters;
    }

    public static enum State {
        success,
        timeout,
        exception,
        oom;

    }
}

