/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Map;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;

public class Binning {
    private static Binning NONE = new Binning(BinningType.NONE, -1);
    private final BinningType type;
    private final int binCount;

    public static Binning none() {
        return NONE;
    }

    public static Binning equalFrequency(int binCount) {
        return new Binning(BinningType.BINNED_EQUAL_FREQUENCY, binCount);
    }

    public static Binning equalWidth(int binCount) {
        return new Binning(BinningType.BINNED_EQUAL_WIDTH, binCount);
    }

    private Binning(BinningType type, int binCount) {
        this.type = type;
        this.binCount = binCount;
    }

    @JsonValue
    public String toString() {
        String typeString = this.type.name().toLowerCase();
        return this.binCount <= 0 ? typeString : typeString + "_" + this.binCount;
    }

    @JsonCreator
    public static Binning fromString(String binning) {
        if (binning == null || binning.isEmpty()) {
            return null;
        }
        if ("none".equalsIgnoreCase(binning)) {
            return NONE;
        }
        return Binning.readBinning(binning);
    }

    private static Binning readBinning(String binning) {
        int p = binning.lastIndexOf(95);
        if (p <= 0) {
            return null;
        }
        BinningType type = Binning.getType(binning, p);
        if (type == null) {
            return null;
        }
        int binCount = -1;
        if (p > 0) {
            try {
                binCount = Integer.parseInt(binning.substring(p + 1));
            }
            catch (NumberFormatException ignored) {
                return null;
            }
        }
        return new Binning(type, binCount);
    }

    private static BinningType getType(String binning, int p) {
        String typeString = binning.substring(0, p);
        BinningType type = null;
        for (BinningType binningType : BinningType.values()) {
            if (!typeString.equalsIgnoreCase(binningType.toString())) continue;
            type = binningType;
        }
        return type;
    }

    public JSONObject toJSON() throws JSONException {
        if (this.type == BinningType.NONE) {
            return null;
        }
        JSONObject o = new JSONObject();
        JSONObject b1 = new JSONObject();
        if (this.binCount > 0) {
            b1.put("numberOfBins", this.binCount);
        }
        o.put("auto", (Map)b1);
        return o;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Binning binning = (Binning)o;
        return binning.type == this.type && binning.binCount == this.binCount;
    }

    public int hashCode() {
        return this.type.ordinal() + this.binCount * 10;
    }

    private static enum BinningType {
        NONE,
        BINNED_EQUAL_FREQUENCY,
        BINNED_EQUAL_WIDTH;

    }
}

