/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.types;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public interface Identifiable {
    public String id();

    public static <T extends Identifiable> T find(String id, T[] collection) {
        for (T t : collection) {
            if (t == null || !t.id().equals(id)) continue;
            return t;
        }
        return null;
    }

    public static <T extends Identifiable> T find(String id, Collection<T> collection) {
        for (Identifiable t : collection) {
            if (t == null || !t.id().equals(id)) continue;
            return (T)t;
        }
        return null;
    }

    public static <T extends Identifiable> Map<String, T> asMap(Collection<T> items) {
        return items.stream().collect(Collectors.toMap(Identifiable::id, Function.identity()));
    }

    public static <T extends Identifiable> Map<String, T> asMap(T ... items) {
        return Arrays.stream(items).collect(Collectors.toMap(Identifiable::id, Function.identity()));
    }
}

