/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.math.NumericUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Count<T extends Comparable<T>> {
    private final Map<T, Entry<T>> contents;
    private double totalCount = 0.0;

    public static <R, T extends Comparable<T>> Count<T> of(Stream<? extends R> input, Function<R, T> keyFunction, ToDoubleFunction<R> valueFunction) {
        return input.collect(Count::new, (count, item) -> count.increment((Comparable)keyFunction.apply(item), valueFunction.applyAsDouble(item)), Count::addAll);
    }

    public static <T extends Comparable<T>> Collector<T, Count<T>, Count<T>> collector() {
        return new CountCollector();
    }

    private static <T extends Comparable<T>> double simpleIncrement(T item, Map<T, Entry<T>> map) {
        Entry<T> e = map.get(item);
        if (e == null) {
            map.put(item, new Entry(item, 1.0, null));
            return 1.0;
        }
        return ((Entry)e).count += 1.0;
    }

    private Count(HashMap<T, Entry<T>> map) {
        this.contents = map;
    }

    public Count() {
        this(new HashMap(32));
    }

    public synchronized Count<T> addAll(Count<T> other) {
        other.contents.values().forEach(e -> this.increment(((Entry)e).item, ((Entry)e).count));
        return this;
    }

    public synchronized void clear() {
        this.contents.clear();
        this.totalCount = 0.0;
    }

    public synchronized boolean contains(T item) {
        return this.contents.containsKey(item);
    }

    public synchronized Count<T> copy() {
        Count<T> copy = new Count<T>();
        for (Map.Entry<T, Entry<T>> entry : this.contents.entrySet()) {
            copy.contents.put(entry.getKey(), entry.getValue().copy());
        }
        copy.totalCount = this.totalCount;
        return copy;
    }

    public synchronized double get(T item) {
        Entry<T> entry = this.contents.get(item);
        return entry == null ? 0.0 : ((Entry)entry).count;
    }

    public synchronized double get(T item, double defaultCount) {
        Entry<T> entry = this.contents.get(item);
        return entry == null ? defaultCount : ((Entry)entry).count;
    }

    public synchronized List<T> getAllValues() {
        return new ArrayList<T>(this.contents.keySet());
    }

    public synchronized boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Count)) {
            return false;
        }
        Count count = (Count)o;
        return NumericUtils.equals(this.totalCount, count.totalCount) && this.contents.equals(count.contents);
    }

    public synchronized int hashCode() {
        return this.contents.hashCode();
    }

    public synchronized double increment(T item) {
        this.totalCount += 1.0;
        return Count.simpleIncrement(item, this.contents);
    }

    public synchronized double increment(T item, double count) {
        Entry<T> entry = this.contents.get(item);
        if (entry == null) {
            if (count < 0.0) {
                throw new IllegalArgumentException("Counts must be strictly positive");
            }
            this.contents.put(item, new Entry((Comparable)item, count, null));
            this.totalCount += count;
            return count;
        }
        if (((Entry)entry).count + count < 0.0) {
            throw new IllegalArgumentException("Counts must be strictly positive");
        }
        ((Entry)entry).count = ((Entry)entry).count + count;
        this.totalCount += count;
        return ((Entry)entry).count;
    }

    public synchronized boolean isEmpty() {
        return this.contents.isEmpty();
    }

    public synchronized Set<T> keySet() {
        return this.contents.keySet();
    }

    public synchronized T mostFrequentEntry() {
        Comparable result = null;
        double best = 0.0;
        for (Entry<T> entry : this.contents.values()) {
            if (!(((Entry)entry).count > best)) continue;
            best = ((Entry)entry).count;
            result = ((Entry)entry).item;
        }
        return (T)result;
    }

    public synchronized Count<T> normalize(double newTotalCount) {
        double ratio = newTotalCount / this.totalCount;
        return Count.of(this.contents.values().stream(), e -> ((Entry)e).item, e -> ((Entry)e).count * ratio);
    }

    public synchronized Entry<T> remove(T item) {
        Entry<T> entry = this.contents.remove(item);
        if (entry != null) {
            this.totalCount -= ((Entry)entry).count;
        }
        return entry;
    }

    public synchronized void removeIf(BiPredicate<T, Double> test) {
        this.contents.entrySet().removeIf((? super E e) -> test.test(e.getKey(), ((Entry)e.getValue()).count));
    }

    public synchronized void set(T item, double value) {
        this.increment(item, value - this.get(item));
    }

    public synchronized int size() {
        return this.contents.size();
    }

    public synchronized Stream<Entry<T>> stream() {
        return this.contents.values().stream();
    }

    public synchronized double totalCount() {
        return this.totalCount;
    }

    public String toString() {
        return this.stream().sorted().map(Entry::toString).collect(Collectors.joining(", "));
    }

    private static final class CountCollector<T extends Comparable<T>>
    implements Collector<T, Count<T>, Count<T>> {
        private static final HashSet<Collector.Characteristics> CHARACTERISTICS = new HashSet<Collector.Characteristics>(Arrays.asList(Collector.Characteristics.CONCURRENT, Collector.Characteristics.IDENTITY_FINISH));

        private CountCollector() {
        }

        @Override
        public Supplier<Count<T>> supplier() {
            return Count::new;
        }

        @Override
        public BiConsumer<Count<T>, T> accumulator() {
            return Count::increment;
        }

        @Override
        public BinaryOperator<Count<T>> combiner() {
            return Count::addAll;
        }

        @Override
        public Function<Count<T>, Count<T>> finisher() {
            return a -> a;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return CHARACTERISTICS;
        }
    }

    public static final class Entry<T extends Comparable<T>>
    implements Comparable<Entry<T>> {
        private final T item;
        private double count;

        private Entry(T item, double count) {
            this.item = item;
            this.count = count;
        }

        @Override
        public int compareTo(Entry<T> o) {
            if (this == o) {
                return 0;
            }
            int d = Double.compare(o.count, this.count);
            return d != 0 ? d : this.item.compareTo(o.item);
        }

        public Entry<T> copy() {
            return new Entry<T>(this.item, this.count);
        }

        public double count() {
            return this.count;
        }

        public T item() {
            return this.item;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry entry = (Entry)o;
            return NumericUtils.equals(this.count, entry.count) && this.item.equals(entry.item);
        }

        public int hashCode() {
            long temp = Double.doubleToLongBits(this.count);
            int result = 31 + (int)(temp ^ temp >>> 32);
            return 31 * result + this.item.hashCode();
        }

        public String toString() {
            return this.item.toString() + "=" + this.count;
        }

        /* synthetic */ Entry(Comparable x0, double x1, 1 x2) {
            this(x0, x1);
        }
    }
}

