/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.google.common.base.Stopwatch;
import com.ibm.bi.predict.utils.Logger;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class PredictLoggerFactory {
    private static final Marker PERF = MarkerFactory.getMarker((String)"PERF");

    private PredictLoggerFactory() {
    }

    public static Logger getLogger(Class<?> clazz) {
        return new LoggerImpl(LoggerFactory.getLogger(clazz));
    }

    static class LoggerImpl
    implements Logger {
        private final org.slf4j.Logger log;
        private final ThreadLocal<Stopwatch> timer = new ThreadLocal();

        LoggerImpl(org.slf4j.Logger log) {
            this.log = log;
        }

        public String getName() {
            return this.log.getName();
        }

        public boolean isTraceEnabled() {
            return this.log.isDebugEnabled();
        }

        public void trace(String msg) {
            this.log.trace(msg);
        }

        public void trace(String format, Object arg) {
            this.log.trace(format, arg);
        }

        public void trace(String format, Object arg1, Object arg2) {
            this.log.trace(format, arg1, arg2);
        }

        public void trace(String format, Object ... arguments) {
            this.log.trace(format, arguments);
        }

        public void trace(String msg, Throwable t) {
            this.log.trace(msg, t);
        }

        public boolean isTraceEnabled(Marker marker) {
            return this.log.isTraceEnabled(marker);
        }

        public void trace(Marker marker, String msg) {
            this.log.trace(marker, msg);
        }

        public void trace(Marker marker, String format, Object arg) {
            this.log.trace(marker, format, arg);
        }

        public void trace(Marker marker, String format, Object arg1, Object arg2) {
            this.log.trace(marker, format, arg1, arg2);
        }

        public void trace(Marker marker, String format, Object ... argArray) {
            this.log.trace(marker, format, argArray);
        }

        public void trace(Marker marker, String msg, Throwable t) {
            this.log.trace(marker, msg, t);
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String msg) {
            this.log.debug(msg);
        }

        public void debug(String format, Object arg) {
            this.log.debug(format, arg);
        }

        public void debug(String format, Object arg1, Object arg2) {
            this.log.debug(format, arg1, arg2);
        }

        public void debug(String format, Object ... arguments) {
            this.log.debug(format, arguments);
        }

        public void debug(String msg, Throwable t) {
            this.log.debug(msg, t);
        }

        public boolean isDebugEnabled(Marker marker) {
            return this.log.isDebugEnabled(marker);
        }

        public void debug(Marker marker, String msg) {
            this.log.debug(marker, msg);
        }

        public void debug(Marker marker, String format, Object arg) {
            this.log.debug(marker, format, arg);
        }

        public void debug(Marker marker, String format, Object arg1, Object arg2) {
            this.log.debug(marker, format, arg1, arg2);
        }

        public void debug(Marker marker, String format, Object ... arguments) {
            this.log.debug(marker, format, arguments);
        }

        public void debug(Marker marker, String msg, Throwable t) {
            this.log.debug(marker, msg, t);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String msg) {
            this.log.info(msg);
        }

        public void info(String format, Object arg) {
            this.log.info(format, arg);
        }

        public void info(String format, Object arg1, Object arg2) {
            this.log.info(format, arg1, arg2);
        }

        public void info(String format, Object ... arguments) {
            this.log.info(format, arguments);
        }

        public void info(String msg, Throwable t) {
            this.log.info(msg, t);
        }

        public boolean isInfoEnabled(Marker marker) {
            return this.log.isInfoEnabled();
        }

        public void info(Marker marker, String msg) {
            this.log.info(marker, msg);
        }

        public void info(Marker marker, String format, Object arg) {
            this.log.info(marker, format, arg);
        }

        public void info(Marker marker, String format, Object arg1, Object arg2) {
            this.log.info(marker, format, arg1, arg2);
        }

        public void info(Marker marker, String format, Object ... arguments) {
            this.log.info(marker, format, arguments);
        }

        public void info(Marker marker, String msg, Throwable t) {
            this.log.info(marker, msg, t);
        }

        public boolean isWarnEnabled() {
            return this.log.isWarnEnabled();
        }

        public void warn(String msg) {
            this.log.warn(msg);
        }

        public void warn(String format, Object arg) {
            this.log.warn(format, arg);
        }

        public void warn(String format, Object ... arguments) {
            this.log.warn(format, arguments);
        }

        public void warn(String format, Object arg1, Object arg2) {
            this.log.warn(format, arg1, arg2);
        }

        public void warn(String msg, Throwable t) {
            this.log.warn(msg, t);
        }

        public boolean isWarnEnabled(Marker marker) {
            return this.log.isWarnEnabled(marker);
        }

        public void warn(Marker marker, String msg) {
            this.log.warn(marker, msg);
        }

        public void warn(Marker marker, String format, Object arg) {
            this.log.warn(marker, format, arg);
        }

        public void warn(Marker marker, String format, Object arg1, Object arg2) {
            this.log.warn(marker, format, arg1, arg2);
        }

        public void warn(Marker marker, String format, Object ... arguments) {
            this.log.warn(marker, format, arguments);
        }

        public void warn(Marker marker, String msg, Throwable t) {
            this.log.warn(marker, msg, t);
        }

        public boolean isErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        public void error(String msg) {
            this.log.error(msg);
        }

        public void error(String format, Object arg) {
            this.log.error(format, arg);
        }

        public void error(String format, Object arg1, Object arg2) {
            this.log.error(format, arg1, arg2);
        }

        public void error(String format, Object ... arguments) {
            this.log.error(format, arguments);
        }

        public void error(String msg, Throwable t) {
            this.log.error(msg, t);
        }

        public boolean isErrorEnabled(Marker marker) {
            return this.log.isErrorEnabled(marker);
        }

        public void error(Marker marker, String msg) {
            this.log.error(marker, msg);
        }

        public void error(Marker marker, String format, Object arg) {
            this.log.error(marker, format, arg);
        }

        public void error(Marker marker, String format, Object arg1, Object arg2) {
            this.log.error(marker, format, arg1, arg2);
        }

        public void error(Marker marker, String format, Object ... arguments) {
            this.log.error(marker, format, arguments);
        }

        public void error(Marker marker, String msg, Throwable t) {
            this.log.error(marker, msg, t);
        }

        @Override
        public void perfStart() {
            this.timer.set(Stopwatch.createStarted());
        }

        @Override
        public void perfLog(String msg) {
            this.log.debug(PERF, this.addTimeFormat(msg), (Object)this.getTime());
        }

        @Override
        public void infoPerfLog(String msg) {
            this.log.info(PERF, this.addTimeFormat(msg), (Object)this.getTime());
        }

        @Override
        public void perfLog(String format, Object arg) {
            this.log.debug(PERF, this.addTimeFormat(format), arg, (Object)this.getTime());
        }

        @Override
        public void infoPerfLog(String format, Object arg) {
            this.log.info(PERF, this.addTimeFormat(format), arg, (Object)this.getTime());
        }

        private String addTimeFormat(String format) {
            return format + " - time={}";
        }

        @Override
        public long getTime() {
            if (this.timer.get() == null) {
                return 0L;
            }
            return this.timer.get().elapsed(TimeUnit.MILLISECONDS);
        }

        @Override
        public Stopwatch getTimer() {
            return this.timer.get();
        }

        @Override
        public void perfBlock(Runnable fn, String name) {
            fn.run();
            this.perfLog(String.format("Block [%s] completed", name));
        }

        @Override
        public void perfStop() {
            this.perfStop(null);
        }

        @Override
        public void perfStop(String msg) {
            if (this.timer.get() == null) {
                return;
            }
            Stopwatch t = this.timer.get();
            if (t.isRunning()) {
                try {
                    if (msg != null) {
                        this.log.debug(PERF, msg + " - time={}", (Object)this.getTime());
                    }
                    this.timer.get().stop();
                }
                catch (IllegalStateException e) {
                    this.log.warn(e.getMessage());
                }
            }
            this.timer.remove();
        }

        @Override
        public void trace(Supplier<?> s) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(s.get().toString());
            }
        }

        @Override
        public void trace(Marker marker, Supplier<?> s) {
            if (this.log.isTraceEnabled(marker)) {
                this.log.trace(marker, s.get().toString());
            }
        }

        @Override
        public void trace(String format, Supplier<?> ... params) {
            if (this.log.isTraceEnabled()) {
                this.log.trace(format, this.makeParams(params));
            }
        }

        @Override
        public void trace(Marker marker, String format, Supplier<?> ... params) {
            if (this.log.isTraceEnabled(marker)) {
                this.log.trace(marker, format, this.makeParams(params));
            }
        }

        @Override
        public void debug(Supplier<?> s) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(s.get().toString());
            }
        }

        @Override
        public void debug(Marker marker, Supplier<?> s) {
            if (this.log.isDebugEnabled(marker)) {
                this.log.debug(marker, s.get().toString());
            }
        }

        @Override
        public void debug(String format, Supplier<?> ... params) {
            if (this.log.isDebugEnabled()) {
                this.log.debug(format, this.makeParams(params));
            }
        }

        @Override
        public void debug(Marker marker, String format, Supplier<?> ... params) {
            if (this.log.isDebugEnabled(marker)) {
                this.log.debug(marker, format, this.makeParams(params));
            }
        }

        @Override
        public void info(Supplier<?> s) {
            if (this.log.isInfoEnabled()) {
                this.log.info(s.get().toString());
            }
        }

        @Override
        public void info(Marker marker, Supplier<?> s) {
            if (this.log.isInfoEnabled(marker)) {
                this.log.info(marker, s.get().toString());
            }
        }

        @Override
        public void info(String format, Supplier<?> ... params) {
            if (this.log.isInfoEnabled()) {
                this.log.info(format, this.makeParams(params));
            }
        }

        @Override
        public void info(Marker marker, String format, Supplier<?> ... params) {
            if (this.log.isInfoEnabled(marker)) {
                this.log.info(marker, format, this.makeParams(params));
            }
        }

        @Override
        public void warn(Supplier<?> s) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(s.get().toString());
            }
        }

        @Override
        public void warn(Supplier<?> s, Throwable cause) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(s.get().toString(), cause);
            }
        }

        @Override
        public void warn(Marker marker, Supplier<?> s) {
            if (this.log.isWarnEnabled(marker)) {
                this.log.warn(marker, s.get().toString());
            }
        }

        @Override
        public void warn(String format, Supplier<?> ... params) {
            if (this.log.isWarnEnabled()) {
                this.log.warn(format, this.makeParams(params));
            }
        }

        @Override
        public void warn(Marker marker, String format, Supplier<?> ... params) {
            if (this.log.isWarnEnabled(marker)) {
                this.log.warn(marker, format, this.makeParams(params));
            }
        }

        @Override
        public void error(Supplier<?> s) {
            if (this.log.isErrorEnabled()) {
                this.log.error(s.get().toString());
            }
        }

        @Override
        public void error(Marker marker, Supplier<?> s) {
            if (this.log.isErrorEnabled()) {
                this.log.error(marker, s.get().toString());
            }
        }

        @Override
        public void error(String format, Supplier<?> ... params) {
            if (this.log.isErrorEnabled()) {
                this.log.error(format, this.makeParams(params));
            }
        }

        @Override
        public void error(Marker marker, String format, Supplier<?> ... params) {
            if (this.log.isErrorEnabled(marker)) {
                this.log.error(marker, format, this.makeParams(params));
            }
        }

        private Object[] makeParams(Supplier<?>[] params) {
            Object[] m = new Object[params.length];
            for (int i = 0; i < params.length; ++i) {
                m[i] = params[i].get();
            }
            return m;
        }
    }
}

