/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import com.ibm.bi.predict.sa.execution.utils.TriFunction;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.ToDoubleBiFunction;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class StreamUtils {
    public static DoubleStream zipDoubles(List<Double> l1, List<Double> l2, ToDoubleBiFunction<Double, Double> fn) {
        return IntStream.range(0, l1.size()).mapToDouble(i -> fn.applyAsDouble((Double)l1.get(i), (Double)l2.get(i)));
    }

    public static <T, U, R> Stream<R> zip(List<T> l1, List<U> l2, BiFunction<T, U, R> fn) {
        return IntStream.range(0, l1.size()).mapToObj(i -> fn.apply(l1.get(i), l2.get(i)));
    }

    public static <T, U, R> Stream<R> zip(List<T> l1, List<U> l2, BiConsumer<T, U> fn) {
        return IntStream.range(0, l1.size()).mapToObj(i -> {
            fn.accept(l1.get(i), l2.get(i));
            return null;
        });
    }

    public static <T, U, R> Stream<R> zipWithIndex(List<T> l1, List<U> l2, TriFunction<T, U, Integer, R> fn) {
        return IntStream.range(0, l1.size()).mapToObj(i -> fn.apply(l1.get(i), l2.get(i), i));
    }

    public static <T> Stream<T> fromIterator(Iterator<T> iter) {
        Iterable iterable = () -> iter;
        return StreamSupport.stream(iterable.spliterator(), false);
    }
}

