/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.predict.utils;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;

public class StringUtils {
    private static final String EMPTY_STRING = "";
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final Charset UTF8 = Charset.forName("utf-8");

    public static boolean sameContents(String a, String b, double precision) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        StreamTokenizer tokA = new StreamTokenizer(new StringReader(a));
        StreamTokenizer tokB = new StreamTokenizer(new StringReader(b));
        try {
            while (true) {
                int type;
                if ((type = tokA.nextToken()) != tokB.nextToken()) {
                    return false;
                }
                if (type == -3) {
                    if (tokA.sval.equals(tokB.sval)) continue;
                    return false;
                }
                if (type == -2) {
                    double diff = Math.abs(tokA.nval - tokB.nval);
                    double max = Math.max(Math.abs(tokA.nval), Math.abs(tokB.nval));
                    if (!(max > 0.0) || !(diff > max * precision)) continue;
                    return false;
                }
                if (type == -1) break;
            }
            return true;
        }
        catch (IOException e) {
            throw new RuntimeException("Should not happen on internal strings", e);
        }
    }

    private StringUtils() {
    }

    public static byte[] toBytes(String s) {
        if (s == null) {
            return null;
        }
        if (s.isEmpty()) {
            return EMPTY_BYTES;
        }
        return s.getBytes(UTF8);
    }

    public static String fromBytes(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        if (bytes.length == 0) {
            return EMPTY_STRING;
        }
        return new String(bytes, UTF8);
    }

    public static boolean containsAll(String target, String ... candidates) {
        for (String candidate : candidates) {
            if (target.contains(candidate)) continue;
            return false;
        }
        return true;
    }

    public static <T> String toString(Collection<T> collection) {
        return StringUtils.toString(collection, ", ");
    }

    public static <T> String toString(Collection<T> collection, String delimiter) {
        return collection.stream().map(Objects::toString).collect(Collectors.joining(delimiter));
    }

    public static String percentDifferenceIn3Characters(double percent, int big, int medium, int small) {
        if (percent > (double)big) {
            return "+++";
        }
        if (percent > (double)medium) {
            return " ++";
        }
        if (percent > (double)small) {
            return "  +";
        }
        if (percent < (double)(-big)) {
            return "---";
        }
        if (percent < (double)(-medium)) {
            return " --";
        }
        if (percent < (double)(-small)) {
            return "  -";
        }
        return "   ";
    }

    public static String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public static boolean isAllUpperCaseIgnoreNumeric(String stringValue) {
        boolean hasLowerCase;
        boolean bl = hasLowerCase = !stringValue.equals(stringValue.toUpperCase());
        return !hasLowerCase;
    }

    public static boolean isAllLowerCaseIgnoreNumeric(String stringValue) {
        boolean hasUpperCase;
        boolean bl = hasUpperCase = !stringValue.equals(stringValue.toLowerCase());
        return !hasUpperCase;
    }
}

