/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.service;

import com.ibm.bi.platform.commons.shared.UserPreferences;
import javax.servlet.http.HttpServletRequest;

public class ServletRequestContext {
    private final HttpServletRequest httpServletRequest;
    private final UserPreferences userPreferences;
    private long metadataRetrievalTime = 0L;

    public ServletRequestContext(HttpServletRequest httpServletRequest, UserPreferences userPreferences) {
        this.httpServletRequest = httpServletRequest;
        this.userPreferences = userPreferences;
    }

    public HttpServletRequest getHttpServletRequest() {
        return this.httpServletRequest;
    }

    public UserPreferences getUserPreferences() {
        return this.userPreferences;
    }

    public String getProductLocale() {
        String locale = null;
        if (this.userPreferences != null) {
            locale = this.userPreferences.getProductLocale();
        }
        if (locale != null) {
            return locale;
        }
        if (this.httpServletRequest != null) {
            return this.httpServletRequest.getLocale().getLanguage();
        }
        return null;
    }

    public void setMetadataRetrievalTime(long t) {
        this.metadataRetrievalTime = t;
    }

    public long getMetadataRetrievalTime() {
        return this.metadataRetrievalTime > 0L ? this.metadataRetrievalTime : 0L;
    }

    public <T> T getAttribute(String name) {
        return (T)this.httpServletRequest.getAttribute(name);
    }

    public <T> T getContextAttribute(String name) {
        return (T)this.httpServletRequest.getServletContext().getAttribute(name);
    }
}

