/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.tls;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.ibm.bi.crypto.tunnel.TlsCredentials;
import com.ibm.bi.crypto.tunnel.TlsCredentialsException;
import com.ibm.bi.crypto.tunnel.utils.Certificates;
import com.ibm.bi.crypto.tunnel.utils.Keys;
import com.ibm.bi.crypto.tunnel.utils.NISTCryptoParams;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Objects;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ClientTlsCredentials
implements TlsCredentials {
    public static final String KEYPAIR_ALIAS = "crypto";
    private KeyStore keyStore;
    private char[] pass;

    private ClientTlsCredentials() throws TlsCredentialsException {
        this("RSA");
    }

    private ClientTlsCredentials(String keyPairAlgorithm) throws TlsCredentialsException {
        this(keyPairAlgorithm, null, null);
    }

    private ClientTlsCredentials(String keyPairAlgorithm, X509Certificate rootCa, PrivateKey rootCaPrivateKey) throws TlsCredentialsException {
        Objects.requireNonNull(keyPairAlgorithm, "keyPairAlgorithm should not be null");
        try {
            this.keyStore = KeyStore.getInstance("BKS", (Provider)new BouncyCastleProvider());
            this.pass = Keys.randomPassword(8);
            this.keyStore.load(null, this.pass);
            KeyPair keyPair = Keys.newKeyPair(keyPairAlgorithm, NISTCryptoParams.INSTANCE.keyLength(keyPairAlgorithm));
            X509Certificate clientTargetCert = this.clientTargetCert(keyPairAlgorithm, keyPair, rootCa, rootCaPrivateKey);
            Certificate[] clientCertChain = rootCa != null && rootCaPrivateKey != null ? new X509Certificate[]{clientTargetCert, rootCa} : new X509Certificate[]{clientTargetCert};
            this.keyStore.setKeyEntry(KEYPAIR_ALIAS, keyPair.getPrivate(), this.pass, clientCertChain);
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not create a new ClientTlsCredentials", e);
        }
    }

    private ClientTlsCredentials(KeyStore keyStore, char[] pass) throws TlsCredentialsException {
        try {
            Key key = keyStore.getKey(KEYPAIR_ALIAS, pass);
            Preconditions.checkArgument((key != null && key instanceof PrivateKey ? 1 : 0) != 0, (Object)"the recovered keystore doesn't contain the target private key");
            Certificate[] certificateChain = keyStore.getCertificateChain(KEYPAIR_ALIAS);
            Preconditions.checkArgument((certificateChain != null && certificateChain.length > 0 ? 1 : 0) != 0, (Object)"the recovered keystore doesn't contain the target cert chain");
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not create ClientTlsCredentials from given keystore and password", e);
        }
        this.keyStore = keyStore;
        this.pass = pass;
    }

    public static ClientTlsCredentials newClientTlsCredentials() throws TlsCredentialsException {
        return new ClientTlsCredentials();
    }

    public static ClientTlsCredentials newClientTlsCredentials(String keyPairAlgorithm) throws TlsCredentialsException {
        return new ClientTlsCredentials(keyPairAlgorithm);
    }

    public static ClientTlsCredentials newClientTlsCredentials(String keyPairAlgorithm, X509Certificate rootCaCertificate, PrivateKey rootCaPrivateKey) throws TlsCredentialsException {
        return new ClientTlsCredentials(keyPairAlgorithm, rootCaCertificate, rootCaPrivateKey);
    }

    public static ClientTlsCredentials deserialize(InputStream inputStream) throws TlsCredentialsException {
        Objects.requireNonNull(inputStream, "the credentials input stream should not be null");
        try {
            byte[] bytes = IOUtils.toByteArray((InputStream)inputStream);
            char[] pass = new String(Arrays.copyOf(bytes, 8), StandardCharsets.UTF_8).toCharArray();
            byte[] content = Arrays.copyOfRange(bytes, 8, bytes.length);
            KeyStore keyStore = KeyStore.getInstance("BKS", (Provider)new BouncyCastleProvider());
            keyStore.load(new ByteArrayInputStream(content), pass);
            return new ClientTlsCredentials(keyStore, pass);
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not deserialize a ClientTlsCredentials from given stream", e);
        }
    }

    private X509Certificate clientTargetCert(String keyPairAlgorithm, KeyPair keyPair, X509Certificate rootCa, PrivateKey rootCaPrivateKey) {
        if (rootCa != null && rootCaPrivateKey != null) {
            byte[] clientTargetCertCsr = Certificates.certificateRequestPkcs10PemEncoded(new X500Principal("CN=sg.cognos.ibm, OU=Cognos, O=IBM, C=CA"), keyPair.getPrivate(), keyPair.getPublic(), NISTCryptoParams.INSTANCE.signatureAlgorithm(keyPairAlgorithm));
            return Certificates.signedCertificate(rootCa, rootCaPrivateKey, clientTargetCertCsr, NISTCryptoParams.INSTANCE.signatureAlgorithm(rootCaPrivateKey.getAlgorithm()), new Date(), 365, false);
        }
        return Certificates.selfSignedCertificate(new X500Principal("CN=sg.cognos.ibm, OU=Cognos, O=IBM, C=CA"), keyPair.getPrivate(), keyPair.getPublic(), NISTCryptoParams.INSTANCE.signatureAlgorithm(keyPairAlgorithm), 365);
    }

    public void serialize(OutputStream outputStream) throws TlsCredentialsException {
        Objects.requireNonNull(outputStream, "the credentials output stream should not be null");
        try {
            IOUtils.write((byte[])new String(this.pass).getBytes(StandardCharsets.UTF_8), (OutputStream)outputStream);
            this.keyStore.store(outputStream, this.pass);
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not serialize ClientTlsCredentials to OutputStream", e);
        }
    }

    public void addTrustedCertificate(X509Certificate trustedCert) throws TlsCredentialsException {
        Objects.requireNonNull(trustedCert, "the certificate should not be null");
        try {
            String alias = trustedCert.getSubjectX500Principal().getName().toLowerCase();
            this.keyStore.setCertificateEntry(alias, trustedCert);
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not add trusted cert", e);
        }
    }

    @Override
    public PrivateKey key() throws TlsCredentialsException {
        try {
            return (PrivateKey)this.keyStore.getKey(KEYPAIR_ALIAS, this.pass);
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not retrieve target private key", e);
        }
    }

    @Override
    public X509Certificate[] certificateChain() throws TlsCredentialsException {
        try {
            Certificate[] certificateChain = this.keyStore.getCertificateChain(KEYPAIR_ALIAS);
            return (X509Certificate[])Arrays.copyOf(certificateChain, certificateChain.length, X509Certificate[].class);
        }
        catch (KeyStoreException e) {
            throw new TlsCredentialsException("could not retrieve target cert chain", e);
        }
    }

    @Override
    public X509Certificate[] trustedCertificates() throws TlsCredentialsException {
        try {
            ArrayList<X509Certificate> trustedCerts = new ArrayList<X509Certificate>();
            ArrayList<String> aliases = Collections.list(this.keyStore.aliases());
            for (String alias : aliases) {
                if (!this.keyStore.isCertificateEntry(alias)) continue;
                trustedCerts.add((X509Certificate)this.keyStore.getCertificate(alias));
            }
            if (trustedCerts.size() > 0) {
                return trustedCerts.toArray(new X509Certificate[0]);
            }
            return null;
        }
        catch (Exception e) {
            throw new TlsCredentialsException("could not retrieve trusted certificates", e);
        }
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ClientTlsCredentials that = (ClientTlsCredentials)obj;
        try {
            PrivateKey thisKey = this.key();
            PrivateKey thatKey = that.key();
            if (thisKey == null && thatKey == null || thisKey != null && thatKey != null && Arrays.equals(thisKey.getEncoded(), thatKey.getEncoded())) {
                ImmutableSet thatTrustedCertsSet;
                ImmutableSet thisTrustedCertsSet;
                Object[] thisTrustedCerts = this.trustedCertificates();
                Object[] thatTrustedCerts = that.trustedCertificates();
                if (thisTrustedCerts == null && thatTrustedCerts == null) {
                    return true;
                }
                if (thisTrustedCerts != null && thatTrustedCerts != null && (thisTrustedCertsSet = ImmutableSet.builder().add(thisTrustedCerts).build()).equals(thatTrustedCertsSet = ImmutableSet.builder().add(thatTrustedCerts).build())) {
                    return true;
                }
            }
            return false;
        }
        catch (TlsCredentialsException e) {
            return false;
        }
    }

    public int hashCode() {
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        PrivateKey key = null;
        Object[] trustedCerts = null;
        try {
            key = this.key();
            trustedCerts = this.trustedCertificates();
        }
        catch (TlsCredentialsException tlsCredentialsException) {
            // empty catch block
        }
        if (key != null) {
            hashCodeBuilder.append(key.getEncoded());
        }
        if (trustedCerts != null) {
            hashCodeBuilder.append((Object)ImmutableSet.builder().add(trustedCerts).build());
        }
        return hashCodeBuilder.toHashCode();
    }
}

