/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.crypto.tunnel.utils;

import com.google.common.base.Preconditions;
import com.ibm.bi.crypto.tunnel.utils.ErrorCode;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.Locale;
import java.util.Objects;
import java.util.Random;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.RSAPrivateKey;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.RSAPrivateCrtKeyParameters;
import org.bouncycastle.crypto.util.PrivateKeyInfoFactory;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Keys {
    public static final String AES = "AES";
    private static final String upper = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static final String lower = "ABCDEFGHIJKLMNOPQRSTUVWXYZ".toLowerCase(Locale.ROOT);
    private static final String digits = "0123456789";
    private static final char[] symbols = ("ABCDEFGHIJKLMNOPQRSTUVWXYZ" + lower + "0123456789").toCharArray();
    private static final Random random = new SecureRandom();
    private static final Logger LOGGER = LoggerFactory.getLogger(Keys.class);
    private static final String PEM_PRIVATE_KEY_SUFFIX = "PRIVATE KEY";

    private Keys() {
    }

    public static SecretKey randomAesSecretKey(int size) {
        Preconditions.checkArgument((size == 128 || size == 256 ? 1 : 0) != 0, (Object)"aes key size should be 128 or 256");
        try {
            KeyGenerator keyGen = KeyGenerator.getInstance(AES);
            keyGen.init(size);
            return keyGen.generateKey();
        }
        catch (Exception e) {
            throw ErrorCode.SECRET_KEY_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static SecretKey aesSecretKeyFromEncodedFormat(byte[] encodedKey) {
        Objects.requireNonNull(encodedKey);
        return new SecretKeySpec(encodedKey, AES);
    }

    public static SecretKey aesSecretKeyFromPassword(char[] password) {
        Objects.requireNonNull(password);
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA512");
            PBEKeySpec spec = new PBEKeySpec(password, "SALTYWALTY".getBytes(StandardCharsets.UTF_8), 10000, 256);
            SecretKey tmp = factory.generateSecret(spec);
            SecretKeySpec secret = new SecretKeySpec(tmp.getEncoded(), AES);
            return new SecretKeySpec(secret.getEncoded(), AES);
        }
        catch (Exception e) {
            throw ErrorCode.SECRET_KEY_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static SecretKey aesSecretKeyFromPassword(String password) {
        Objects.requireNonNull(password);
        return Keys.aesSecretKeyFromPassword(password.toCharArray());
    }

    public static KeyPair newKeyPair(String algorithm, int size) {
        Objects.requireNonNull(algorithm);
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"key pair key size should be positive");
        try {
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(algorithm.toLowerCase());
            keyPairGenerator.initialize(size);
            return keyPairGenerator.generateKeyPair();
        }
        catch (Exception e) {
            throw ErrorCode.KEY_PAIR_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static char[] randomPassword(int length) {
        Preconditions.checkArgument((length > 1 ? 1 : 0) != 0, (Object)"password length should be greater then 1");
        char[] password = new char[length];
        for (int i = 0; i < password.length; ++i) {
            password[i] = symbols[random.nextInt(symbols.length)];
        }
        return password;
    }

    public static PrivateKey fromNonEncryptedPkcs8(InputStream inputStream, String privateKeyAlgorithm) {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(privateKeyAlgorithm);
        try {
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(pemReader.readPemObject().getContent());
            KeyFactory kf = KeyFactory.getInstance(privateKeyAlgorithm);
            return kf.generatePrivate(keySpec);
        }
        catch (Exception e) {
            throw ErrorCode.PRIVATE_KEY_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static PrivateKey fromPemEncodedPkcs8Encrypted(InputStream keySource, char[] password, String cryptoAlgorithm) {
        try {
            Objects.requireNonNull(keySource);
            Objects.requireNonNull(cryptoAlgorithm);
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(keySource, StandardCharsets.UTF_8));
            EncryptedPrivateKeyInfo pkInfo = new EncryptedPrivateKeyInfo(pemReader.readPemObject().getContent());
            PBEKeySpec keySpec = new PBEKeySpec(password);
            SecretKeyFactory pbeKeyFactory = SecretKeyFactory.getInstance(pkInfo.getAlgName());
            PKCS8EncodedKeySpec encodedKeySpec = pkInfo.getKeySpec(pbeKeyFactory.generateSecret(keySpec));
            KeyFactory keyFactory = KeyFactory.getInstance(cryptoAlgorithm);
            return keyFactory.generatePrivate(encodedKeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs8", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (IOException | InvalidKeySpecException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs8", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            LOGGER.error("Exception occurred while loading private key from pkcs8", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static byte[] pemEncodedPkcs1(PrivateKey privateKey) {
        try {
            Objects.requireNonNull(privateKey);
            Objects.requireNonNull(privateKey.getAlgorithm(), "private key algorithm shouldn't be null");
            String algorithm = privateKey.getAlgorithm().toUpperCase();
            Preconditions.checkArgument((boolean)algorithm.equalsIgnoreCase("RSA"), (Object)"PKCS1 generation is only supported for RSA private keys");
            String pemID = algorithm + " " + PEM_PRIVATE_KEY_SUFFIX;
            byte[] privateKeyPkcs8 = privateKey.getEncoded();
            PrivateKeyInfo pkInfo = PrivateKeyInfo.getInstance((Object)privateKeyPkcs8);
            ASN1Encodable encodable = pkInfo.parsePrivateKey();
            ASN1Primitive primitive = encodable.toASN1Primitive();
            byte[] privateKeyPkcs1 = primitive.getEncoded();
            if (privateKeyPkcs1 != null) {
                PemObject pemObject = new PemObject(pemID, privateKeyPkcs1);
                ByteArrayOutputStream pemBytesSink = new ByteArrayOutputStream();
                PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)pemBytesSink, StandardCharsets.UTF_8));
                pemWriter.writeObject(() -> pemObject);
                pemWriter.close();
                return pemBytesSink.toByteArray();
            }
            return null;
        }
        catch (IOException e) {
            LOGGER.error("Exception occurred while generating pem encoded private key", (Throwable)e);
            throw ErrorCode.PRIVATE_KEY_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static byte[] pemEncodedPkcs8(PrivateKey privateKey) {
        try {
            Objects.requireNonNull(privateKey);
            String pemID = PEM_PRIVATE_KEY_SUFFIX;
            byte[] privateKeyPkcs8 = privateKey.getEncoded();
            PemObject pemObject = new PemObject(pemID, privateKeyPkcs8);
            ByteArrayOutputStream pemBytesSink = new ByteArrayOutputStream();
            PemWriter pemWriter = new PemWriter((Writer)new OutputStreamWriter((OutputStream)pemBytesSink, StandardCharsets.UTF_8));
            pemWriter.writeObject(() -> pemObject);
            pemWriter.close();
            return pemBytesSink.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error("Exception occurred while generating pem encoded private key", (Throwable)e);
            throw ErrorCode.PRIVATE_KEY_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static PrivateKey fromPemEncodedPkcs1(InputStream inputStream, String privateKeyAlgorithm) {
        Objects.requireNonNull(inputStream);
        Objects.requireNonNull(privateKeyAlgorithm, "private key algorithm shouldn't be null");
        Preconditions.checkArgument((boolean)privateKeyAlgorithm.equalsIgnoreCase("RSA"), (Object)"PKCS1 generation is only supported for RSA private keys");
        try {
            PemReader pemReader = new PemReader((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            RSAPrivateKey rsa = RSAPrivateKey.getInstance((Object)pemReader.readPemObject().getContent());
            RSAPrivateCrtKeyParameters privateKeyParameter = new RSAPrivateCrtKeyParameters(rsa.getModulus(), rsa.getPublicExponent(), rsa.getPrivateExponent(), rsa.getPrime1(), rsa.getPrime2(), rsa.getExponent1(), rsa.getExponent2(), rsa.getCoefficient());
            return new JcaPEMKeyConverter().getPrivateKey(PrivateKeyInfoFactory.createPrivateKeyInfo((AsymmetricKeyParameter)privateKeyParameter));
        }
        catch (Exception e) {
            throw ErrorCode.PRIVATE_KEY_GENERATION_ERROR.exception(e, new Object[0]);
        }
    }

    public static void maskSecretKey(SecretKey secretKey) {
        if (secretKey instanceof SecretKeySpec) {
            try {
                SecretKeySpec spec = (SecretKeySpec)secretKey;
                Class<SecretKeySpec> type = SecretKeySpec.class;
                Field valueField = type.getDeclaredField("key");
                valueField.setAccessible(true);
                byte[] key = (byte[])valueField.get(spec);
                for (int i = 0; i < key.length; ++i) {
                    key[i] = 0;
                }
                valueField.set(spec, null);
            }
            catch (Exception e) {
                LOGGER.info("could not mask secret key", (Throwable)e);
            }
        }
    }
}

