/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1;

import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.qls.format.exception.InvalidFormatPatternException;
import com.ibm.cognos.qls.format.exception.QLSFormattingMessageKeys;
import com.ibm.cognos.qls.format.impl.AbstractValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import java.util.Locale;

public abstract class AbstractTM1ValueFormat
extends AbstractValueFormat {
    public static final String FORM_FEED = "\f";
    public static final String PREFIX_BUILDIN_PTN = "b:";
    public static final String PREFIX_CUSTOM_PTN = "c:";
    public static final String PREFIX_ICU_PTN = "d:";
    public static final String ICU_CUSTOM_PTN = "\fIC";
    protected final TM1NumericPatternInfo ptnInfo;
    protected final String whenZero;
    protected final String whenNull;
    protected final boolean isCustom;

    protected AbstractTM1ValueFormat(String formatString, IDataType dataType, Locale loc, TM1NumericPatternInfo patternInfo) {
        super(formatString, dataType, loc);
        if (patternInfo == null) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InternalError, "TM1NumericPatternInfo shouldn't be null");
        }
        this.ptnInfo = patternInfo;
        this.isCustom = patternInfo.isCustom();
        this.whenZero = patternInfo.getZeroPattern();
        this.whenNull = patternInfo.getNullPattern();
    }

    public TM1NumericPatternInfo getPatternInfo() {
        return this.ptnInfo;
    }

    public String getDigitShaping() {
        return "none";
    }

    public boolean isCustom() {
        return this.isCustom;
    }

    public String getDsFormatString() {
        return this.dsFormatString;
    }

    public String getWhenZero() {
        return this.whenZero;
    }

    public boolean isBlankWhenZero() {
        return this.whenZero != null && this.whenZero.isEmpty();
    }

    public boolean isBlankWhenNull() {
        return this.whenNull != null && this.whenNull.isEmpty();
    }

    public String getWhenNull() {
        return this.whenNull;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getDsFormatString() == null ? 0 : this.getDsFormatString().hashCode()) + (this.getLocale() == null ? 0 : this.getLocale().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        AbstractTM1ValueFormat other = (AbstractTM1ValueFormat)obj;
        if (this.compareObjs(this.getDsFormatString(), other.getDsFormatString())) {
            if (this.compareDataType(other.getDataType())) {
                return this.compareObjs(this.getLocale(), other.getLocale());
            }
            return false;
        }
        return false;
    }
}

