/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1;

import com.ibm.cognos.aurora.api.format.ICurrencyValueFormat;
import com.ibm.cognos.aurora.api.format.IValueFormatCategory;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.qls.format.impl.tm1.TM1CurrencyValueBuildInFormat;
import com.ibm.cognos.qls.format.impl.tm1.TM1CurrencyValueCustomFormat;
import com.ibm.cognos.qls.format.impl.tm1.TM1NumericValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import com.ibm.icu.text.DecimalFormat;
import com.ibm.icu.text.DecimalFormatSymbols;
import com.ibm.icu.text.NumberFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class TM1CurrencyValueFormat
extends TM1NumericValueFormat
implements ICurrencyValueFormat {
    protected String currencySymbol;
    protected String useTrailingSymbol;
    static final String MAPPING_FILE_LOCATION = "/ccli18n_currency_code_symbol_mapping.properties";
    protected static final Set<String> allCurrencyCodes;
    protected static final Set<String> allCurrencySymbols;
    protected static final Map<String, String> currencyCodeSymbolMap;

    public static Map<String, String> getCurrencyCodeSymbolMap() {
        return Collections.unmodifiableMap(currencyCodeSymbolMap);
    }

    public static Set<String> getAllI18nCurrencySymbols() {
        return Collections.unmodifiableSet(allCurrencySymbols);
    }

    public static Set<String> getAllI18nCurrencyCodes() {
        return Collections.unmodifiableSet(allCurrencyCodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(String location) throws IOException {
        Properties props;
        block10: {
            props = new Properties();
            InputStream in = null;
            BufferedReader inReader = null;
            try {
                in = TM1CurrencyValueFormat.class.getResourceAsStream(location);
                if (in == null) {
                    in = ClassLoader.getSystemResourceAsStream(location);
                }
                if (in != null) {
                    inReader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    props.load(inReader);
                    break block10;
                }
                throw new IOException(String.format("%s is missing.", location));
            }
            finally {
                if (inReader != null) {
                    try {
                        inReader.close();
                    }
                    catch (Throwable ignore) {}
                }
            }
        }
        return props;
    }

    protected TM1CurrencyValueFormat(String inFormatString, IDataType inDataType, Locale inLocale, TM1NumericPatternInfo patternInfo) {
        super(inFormatString, inDataType, inLocale, patternInfo);
        this.format = (DecimalFormat)NumberFormat.getCurrencyInstance((Locale)this.locale);
        DecimalFormatSymbols symbols = this.format.getDecimalFormatSymbols();
        symbols.setZeroDigit('0');
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getUseTrailingSymbol() {
        return this.useTrailingSymbol;
    }

    public IValueFormatCategory getValueFormatCategory() {
        return IValueFormatCategory.ICurrencyValueFormat;
    }

    public static ICurrencyValueFormat createInstance(String inFormatString, IDataType dataType, Locale locale, TM1NumericPatternInfo patternInfo) {
        if (patternInfo.isCustom()) {
            return new TM1CurrencyValueCustomFormat(inFormatString, dataType, locale, patternInfo);
        }
        return new TM1CurrencyValueBuildInFormat(inFormatString, dataType, locale, patternInfo);
    }

    static {
        block5: {
            allCurrencyCodes = new HashSet<String>();
            allCurrencySymbols = new HashSet<String>();
            currencyCodeSymbolMap = new HashMap<String, String>();
            try {
                Properties props = TM1CurrencyValueFormat.loadProperties(MAPPING_FILE_LOCATION);
                Set<Map.Entry<Object, Object>> entrySet = props.entrySet();
                for (Map.Entry<Object, Object> entry : entrySet) {
                    currencyCodeSymbolMap.put((String)entry.getKey(), (String)entry.getValue());
                }
                allCurrencyCodes.addAll(currencyCodeSymbolMap.keySet());
                allCurrencySymbols.addAll(currencyCodeSymbolMap.values());
            }
            catch (IOException ioe) {
                if (logger.isWarnEnabled()) {
                    logger.warn(ioe.getLocalizedMessage(), TM1CurrencyValueFormat.class.getName(), (Throwable)ioe);
                }
            }
            catch (Exception ex) {
                if (!logger.isWarnEnabled()) break block5;
                logger.warn(ex.getLocalizedMessage(), TM1CurrencyValueFormat.class.getName(), (Throwable)ex);
            }
        }
    }
}

