/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1;

import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1BuildInNumericPatternInfo;
import com.ibm.icu.text.DecimalFormat;
import java.util.regex.Pattern;

public class TM1NumericBuildInFormatHelper {
    public static void processCommonBuildInSections(DecimalFormat format, TM1BuildInNumericPatternInfo buildInPatternInfo) {
        TM1NumericBuildInFormatHelper.setPrecision(format, buildInPatternInfo);
        TM1NumericBuildInFormatHelper.processNegativePattern(format, buildInPatternInfo);
        TM1NumericBuildInFormatHelper.processGroupSeparators(format, buildInPatternInfo);
    }

    private static void setPrecision(DecimalFormat format, TM1BuildInNumericPatternInfo buildInPatternInfo) {
        if (buildInPatternInfo.isGeneral()) {
            format.setMaximumFractionDigits(6);
            format.setMinimumFractionDigits(0);
        } else {
            format.setMaximumFractionDigits((int)buildInPatternInfo.getDecimalSize());
            format.setMinimumFractionDigits((int)buildInPatternInfo.getDecimalSize());
        }
    }

    private static void processGroupSeparators(DecimalFormat format, TM1BuildInNumericPatternInfo buildInPatternInfo) {
        if (buildInPatternInfo.getUsingGroupSeparators().equalsIgnoreCase("Y")) {
            format.setGroupingUsed(true);
        } else if (buildInPatternInfo.getUsingGroupSeparators().equalsIgnoreCase("N")) {
            format.setGroupingUsed(false);
        }
    }

    private static void processNegativePattern(DecimalFormat format, TM1BuildInNumericPatternInfo buildInPatternInfo) {
        if (buildInPatternInfo.getUseParentheses().equalsIgnoreCase("Y")) {
            TM1NumericBuildInFormatHelper.addBracketInNegativePattern(format);
        } else if (buildInPatternInfo.getUseParentheses().equalsIgnoreCase("N")) {
            TM1NumericBuildInFormatHelper.removeBracketInNegativePattern(format);
        }
    }

    private static void removeBracketInNegativePattern(DecimalFormat format) {
        if (format.getNegativePrefix().startsWith("(")) {
            String nPrefix = format.getNegativePrefix().replaceFirst(Pattern.quote("("), "-");
            format.setNegativePrefix(nPrefix);
            if (format.getNegativeSuffix().endsWith(")")) {
                String nSuffix = format.getNegativeSuffix().replaceAll(Pattern.quote(")"), "");
                format.setNegativeSuffix(nSuffix);
            }
        }
    }

    private static void addBracketInNegativePattern(DecimalFormat format) {
        if (!format.getNegativePrefix().startsWith("(")) {
            String nPrefix = format.getNegativePrefix().replaceAll(Pattern.quote("-"), "");
            format.setNegativePrefix("(" + nPrefix);
            String nSuffix = format.getNegativeSuffix().replaceAll(Pattern.quote("-"), "");
            if (!nSuffix.endsWith(")")) {
                nSuffix = nSuffix + ")";
            }
            format.setNegativeSuffix(nSuffix);
        }
    }
}

