/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1;

import com.ibm.cognos.aurora.api.format.INumericValueFormat;
import com.ibm.cognos.aurora.api.model.datatype.IDataType;
import com.ibm.cognos.aurora.api.model.datatype.NumericType;
import com.ibm.cognos.aurora.api.model.value.IValue;
import com.ibm.cognos.qls.format.impl.tm1.AbstractTM1ValueFormat;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import com.ibm.icu.text.DecimalFormat;
import java.util.Locale;

public abstract class TM1NumericValueFormat
extends AbstractTM1ValueFormat
implements INumericValueFormat {
    protected DecimalFormat format;

    protected TM1NumericValueFormat(String formatString, IDataType inDataType, Locale inLocale, TM1NumericPatternInfo patternInfo) {
        super(formatString, inDataType, inLocale, patternInfo);
    }

    public String getICUFormatPattern() {
        return this.format.toPattern();
    }

    public char getMinusSign() {
        return this.format.getDecimalFormatSymbols().getMinusSign();
    }

    public String getUseTrailingSign() {
        return this.getPatternInfo().getUseTrailingSign();
    }

    public byte getMinimumDecimalSize() {
        return (byte)this.format.getMinimumFractionDigits();
    }

    public byte getMaximumDecimalSize() {
        return (byte)this.format.getMaximumFractionDigits();
    }

    public byte getDecimalSize() {
        return this.getPatternInfo().getDecimalSize();
    }

    public char getDecimalDelimiter() {
        return this.format.getDecimalFormatSymbols().getDecimalSeparator();
    }

    public boolean isUseGrouping() {
        return this.format.isGroupingUsed();
    }

    public byte getGroupingSize() {
        return (byte)this.format.getGroupingSize();
    }

    public char getGroupDelimiter() {
        return this.format.getDecimalFormatSymbols().getGroupingSeparator();
    }

    public String getPositivePrefix() {
        return this.format.getPositivePrefix();
    }

    public String getPositiveSuffix() {
        return this.format.getPositiveSuffix();
    }

    public String getNegativePrefix() {
        return this.format.getNegativePrefix();
    }

    public String getNegativeSuffix() {
        return this.format.getNegativeSuffix();
    }

    public String getUseParentheses() {
        return this.getPatternInfo().getUseParentheses();
    }

    @Override
    protected boolean isTypeCorrect(IValue inValue) {
        return inValue.getType().isNumeric();
    }

    @Override
    protected String formatImpl(IValue inValue) {
        if (inValue.numberValue().intValue() == 0 && this.whenZero != null) {
            return this.whenZero;
        }
        return this.format.format((Object)inValue.numberValue());
    }

    protected NumericType getDataType() {
        return (NumericType)this.dataType;
    }

    @Override
    protected boolean compareDataType(IDataType inType) {
        if (inType == null) {
            return false;
        }
        return inType instanceof NumericType;
    }
}

