/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1.pattern;

import com.ibm.cognos.qls.format.exception.InvalidFormatPatternException;
import com.ibm.cognos.qls.format.exception.QLSFormattingMessageKeys;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1BuildInNumericPatternSubInfo;
import com.ibm.cognos.qls.format.impl.tm1.pattern.TM1NumericPatternInfo;
import java.util.regex.Pattern;

public class TM1BuildInNumericPatternInfo
extends TM1NumericPatternInfo {
    private TM1BuildInNumericPatternSubInfo subInfo;

    public TM1BuildInNumericPatternInfo(String ptn) {
        super(ptn);
        String[] ary = ptn.split(Pattern.quote("\f"));
        this.initPatterns(TM1BuildInNumericPatternInfo.removeEscapeQuote(ary[0]));
        this.initSubInfo(ary[1]);
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("Processing a TM1 build-in format string (%s)", ptn), TM1BuildInNumericPatternInfo.class.getName() + "::TM1BuildInNumericPatternInfo()");
        }
    }

    private void initSubInfo(String buildInfo) {
        this.subInfo = new TM1BuildInNumericPatternSubInfo(buildInfo);
        this.useParentheses = this.subInfo.getUseParentheses();
        if (this.useParentheses.isEmpty()) {
            this.useParentheses = "N";
        }
        this.currencySymbol = this.subInfo.getCurrencySymbol();
        this.decimalSize = this.subInfo.getPrecision();
        if ("P".equals(this.subInfo.getStyle())) {
            this.parsePercentSymbol();
        }
        if (this.isDisplayZeroBlank()) {
            this.setZeroPattern("");
        }
    }

    @Override
    protected void parsePercentSymbol() {
        String ptn = this.getPositivePattern();
        this.percentSymbol = ptn.substring(ptn.length() - 1);
        if (!"%".equals(this.percentSymbol)) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidPercentFormat, this.formatPattern);
        }
    }

    private void initPatterns(String inPtn) {
        this.formatPattern = inPtn;
        String[] ptns = this.formatPattern.split(Pattern.quote(";"));
        if (ptns.length == 1 && "".equals(ptns[0]) || ptns.length > 2) {
            throw new InvalidFormatPatternException(QLSFormattingMessageKeys.GEN_InvalidSectionsFormat, this.formatPattern);
        }
        this.positivePtn = ptns[0];
        if (ptns.length == 2) {
            this.negativePtn = ptns[1];
        }
    }

    @Override
    public boolean isPercentFormat() {
        return this.subInfo.getStyle().equals("P");
    }

    @Override
    public boolean isCurrencyFormat() {
        return this.subInfo.getStyle().equals("C");
    }

    @Override
    public boolean isScientificFormat() {
        return this.subInfo.getStyle().equals("S");
    }

    public boolean isGeneral() {
        return this.subInfo.getStyle().equals("G");
    }

    public TM1BuildInNumericPatternSubInfo getSubInfo() {
        return this.subInfo;
    }

    public String getCurrencySymbolDisplay() {
        return this.subInfo.getCurrencySymbolDisplay();
    }

    public String getUsingGroupSeparators() {
        return this.subInfo.getDisplayGroupSeparators();
    }

    public boolean isDisplayZeroBlank() {
        return this.subInfo.getDisplayZeroBlank().equalsIgnoreCase("Y");
    }

    @Override
    public boolean isCustom() {
        return false;
    }

    public String toString() {
        return "TM1BuildInNumericPatternInfo [subInfo=" + this.subInfo + ", decimalSize=" + this.decimalSize + ", useParentheses=" + this.useParentheses + ", positivePtn=" + this.positivePtn + ", negativePtn=" + this.negativePtn + ", formatPattern=" + this.formatPattern + ", origFormatString=" + this.origFormatString + ", currencySymbol=" + this.currencySymbol + ", percentSymbol=" + this.percentSymbol + ", whenZero=" + this.whenZero + ", whenNull=" + this.whenNull + ", positivePrefix=" + this.positivePrefix + ", positvieSuffix=" + this.positvieSuffix + ", negativePrefix=" + this.negativePrefix + ", negativeSuffix=" + this.negativeSuffix + "]";
    }
}

