/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cognos.qls.format.impl.tm1.pattern;

import java.util.regex.Pattern;

public class TM1BuildInNumericPatternSubInfo {
    private String style = "";
    private byte precision;
    private String useParentheses = "";
    private String currencySymbol = "";
    private String currencySymbolDisplay = "D";
    private String displayGroupSeparators = "D";
    private String displayZeroBlank = "N";
    private static final String FIELD_SEPARATOR = "|";
    public static final String BUILDIN_PERCENT_STYLE = "P";
    public static final String BUILDIN_SCIENTIFIC_STYLE = "S";
    public static final String BUILDIN_CURRENCY_STYLE = "C";
    public static final String BUILDIN_FIXED_STYLE = "F";
    public static final String BUILDIN_COMMA_STYLE = "CO";
    public static final String BUILDIN_GENERAL_STYLE = "G";

    public TM1BuildInNumericPatternSubInfo(String buildin) {
        String[] bdIn = buildin.split(Pattern.quote(FIELD_SEPARATOR));
        this.style = bdIn[0];
        if (this.style.equals(BUILDIN_GENERAL_STYLE)) {
            this.precision = 0;
        }
        if (this.style.equals(BUILDIN_FIXED_STYLE) || this.style.equals(BUILDIN_GENERAL_STYLE)) {
            this.displayGroupSeparators = "N";
        }
        if (this.style.equals(BUILDIN_COMMA_STYLE)) {
            this.displayGroupSeparators = "Y";
        }
        if (bdIn.length > 1) {
            this.precision = Byte.parseByte(bdIn[1]);
        }
        if (bdIn.length > 2) {
            this.useParentheses = bdIn[2];
        }
        if (bdIn.length > 3) {
            this.currencySymbol = bdIn[3];
        }
        if (bdIn.length > 4 && bdIn[4] != null && !bdIn[4].isEmpty()) {
            this.currencySymbolDisplay = bdIn[4];
        }
        if (bdIn.length > 5 && (this.style.equals(BUILDIN_PERCENT_STYLE) || this.style.equals(BUILDIN_CURRENCY_STYLE)) && bdIn[5] != null && !bdIn[5].isEmpty()) {
            this.displayGroupSeparators = bdIn[5];
        }
        if (bdIn.length > 6 && bdIn[6] != null && !bdIn[6].isEmpty()) {
            this.displayZeroBlank = bdIn[6];
        }
    }

    public String getStyle() {
        return this.style;
    }

    public byte getPrecision() {
        return this.precision;
    }

    public String getUseParentheses() {
        return this.useParentheses;
    }

    public String getCurrencySymbol() {
        return this.currencySymbol;
    }

    public String getCurrencySymbolDisplay() {
        return this.currencySymbolDisplay;
    }

    public String getDisplayGroupSeparators() {
        return this.displayGroupSeparators;
    }

    public String getDisplayZeroBlank() {
        return this.displayZeroBlank;
    }

    public String toString() {
        return "TM1BuildInNumericPatternSubInfo [style=" + this.style + ", precision=" + this.precision + ", useParentheses=" + this.useParentheses + ", currencySymbol=" + this.currencySymbol + ", currencySymbolDisplay=" + this.currencySymbolDisplay + ", displayGroupSeparators=" + this.displayGroupSeparators + ", displayZeroBlank=" + this.displayZeroBlank + "]";
    }
}

