/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.api;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum AggregateType {
    DEFAULT("default"),
    SUM("sum"),
    COUNT("count"),
    COUNTDISTINCT("countdistinct"),
    AVG("avg"),
    MIN("min"),
    MAX("max"),
    MEDIAN("median"),
    NULL_COUNT("nullCount"),
    STDDEV("stddev"),
    VARIANCE("variance"),
    NONE("none"),
    UNKNOWN("unknown"),
    UNSUPPORTED("unsupported"),
    AUTOMATIC("automatic"),
    CALCULATED("calculated");

    private final String value;
    private static Map<String, AggregateType> constants;

    private AggregateType(String value) {
        this.value = value;
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @JsonCreator
    public static AggregateType fromValue(String value) {
        AggregateType constant = constants.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        constants = new HashMap<String, AggregateType>();
        for (AggregateType c : AggregateType.values()) {
            constants.put(c.value, c);
        }
    }
}

