/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.api;

import com.cognos.xqe.data.types.IDataType;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ibm.bi.qs.model.api.AggregateType;
import com.ibm.bi.qs.model.api.FieldOrdering;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(value={"xqedataType", "childColumns"})
@JsonPropertyOrder(value={"columnId", "_cId", "columnName", "label", "dataType", "type", "format", "category", "defaultAggregation", "defaultSort", "querySubjectID", "querySubjectLabel", "calculation", "hidden", "sourceCategory", "hierarchyHasMultipleRoots", "parentColumn", "facetEnabled"})
public class ColumnMetadata {
    @JsonProperty(value="columnId")
    private String columnId;
    @JsonProperty(value="parentColumn")
    private ColumnMetadata parentColumn;
    @JsonProperty(value="hierarchy")
    private ColumnMetadata hierarchy;
    @JsonIgnore
    private List<ColumnMetadata> childColumns = new ArrayList<ColumnMetadata>();
    @JsonProperty(value="columnName")
    private String columnName;
    @JsonProperty(value="_cId")
    private String cId;
    @JsonProperty(value="label")
    private String label;
    @JsonProperty(value="dataType")
    private DataType dataType;
    @JsonIgnore
    private IDataType xqeDataType;
    @JsonProperty(value="type")
    private Type type;
    @JsonProperty(value="format")
    private String format;
    @JsonProperty(value="category")
    private String category = "none";
    @JsonProperty(value="defaultAggregation")
    private AggregateType defaultAggregation;
    @JsonProperty(value="defaultSort")
    private FieldOrdering defaultSort;
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();
    @JsonProperty(value="querySubjectID")
    private String querySubjectID;
    @JsonProperty(value="querySubjectLabel")
    private String querySubjectLabel;
    @JsonProperty(value="calculation")
    private Boolean calculation = Boolean.FALSE;
    @JsonProperty(value="hidden")
    private Boolean hidden = Boolean.FALSE;
    @JsonProperty(value="sourceCategory")
    private SourceCategory sourceCategory;
    @JsonProperty(value="hierarchyHasMultipleRoots")
    private boolean hierarchyHasMultipleRoots = false;
    @JsonProperty(value="facetEnabled")
    private FacetEnabled facetEnabled;
    private String[] suggestedStats;
    private boolean isNullable = true;

    @JsonProperty(value="columnId")
    public String getColumnId() {
        return this.columnId;
    }

    @JsonProperty(value="columnId")
    public void setColumnId(String columnId) {
        this.columnId = columnId;
    }

    @JsonProperty(value="parentColumn")
    public ColumnMetadata getParentColumn() {
        return this.parentColumn;
    }

    public boolean isFacetEnabled() {
        return FacetEnabled.AUTOMATIC.equals((Object)this.facetEnabled) || FacetEnabled.TRUE.equals((Object)this.facetEnabled);
    }

    public ColumnMetadata getHierarchy() {
        if (null != this.hierarchy) {
            return this.hierarchy;
        }
        ColumnMetadata column = this;
        if (SourceCategory.PROPERTY.equals((Object)this.sourceCategory)) {
            column = this.getParentColumn();
        }
        if (SourceCategory.LEVEL.equals((Object)column.getSourceCategory())) {
            column = column.getParentColumn();
        }
        if (SourceCategory.HIERARCHY_LEVEL.equals((Object)column.getSourceCategory()) || SourceCategory.HIERARCHY_PARENT_CHILD.equals((Object)column.getSourceCategory())) {
            return column;
        }
        return null;
    }

    public void setHierarchy(ColumnMetadata hierarchy) {
        this.hierarchy = hierarchy;
    }

    @JsonProperty(value="parentColumn")
    public void setParentColumn(ColumnMetadata parent) {
        this.parentColumn = parent;
    }

    @JsonProperty(value="childColumns")
    public List<ColumnMetadata> getChildColumns() {
        return this.childColumns;
    }

    @JsonProperty(value="childColumns")
    public void addChildColumn(ColumnMetadata child) {
        this.childColumns.add(child);
    }

    @JsonProperty(value="columnName")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="columnName")
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @JsonProperty(value="_cId")
    public String getCId() {
        return this.cId;
    }

    @JsonProperty(value="_cId")
    public void setCId(String columnId) {
        this.cId = columnId;
    }

    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    @JsonProperty(value="label")
    public void setLabel(String label) {
        this.label = label;
    }

    @JsonProperty(value="dataType")
    public DataType getDataType() {
        return this.dataType;
    }

    @JsonProperty(value="dataType")
    public void setDataType(DataType dataType) {
        this.dataType = dataType;
    }

    public IDataType getXQEDataType() {
        return this.xqeDataType;
    }

    public void setXQEDataType(IDataType xqeDataType) {
        this.xqeDataType = xqeDataType;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="type")
    public void setType(Type type) {
        this.type = type;
    }

    @JsonProperty(value="format")
    public String getFormat() {
        return this.format;
    }

    @JsonProperty(value="format")
    public void setFormat(String format) {
        this.format = format;
    }

    @JsonProperty(value="category")
    public String getCategory() {
        return this.category;
    }

    @JsonProperty(value="category")
    public void setCategory(String category) {
        this.category = category;
    }

    @JsonProperty(value="defaultAggregation")
    public AggregateType getDefaultAggregation() {
        return this.defaultAggregation;
    }

    @JsonProperty(value="defaultAggregation")
    public void setDefaultAggregation(AggregateType defaultAggregation) {
        this.defaultAggregation = defaultAggregation;
    }

    @JsonProperty(value="defaultSort")
    public FieldOrdering getDefaultSort() {
        return this.defaultSort;
    }

    @JsonProperty(value="defaultSort")
    public void setDefaultSort(FieldOrdering defaultSort) {
        this.defaultSort = defaultSort;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    public boolean equals(Object other) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)other, (String[])new String[0]);
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    @JsonProperty(value="querySubjectID")
    public String getQuerySubjectID() {
        return this.querySubjectID;
    }

    @JsonProperty(value="querySubjectID")
    public void setQuerySubjectID(String querySubjectID) {
        this.querySubjectID = querySubjectID;
    }

    @JsonProperty(value="querySubjectLabel")
    public String getQuerySubjectLabel() {
        return this.querySubjectLabel;
    }

    @JsonProperty(value="querySubjectLabel")
    public void setQuerySubjectLabel(String querySubjectLabel) {
        this.querySubjectLabel = querySubjectLabel;
    }

    public boolean getHierarchyHasMultipleRoots() {
        return this.hierarchyHasMultipleRoots;
    }

    public void setHierarchyHasMultipleRoots(boolean hierarchyHasMultipleRoots) {
        this.hierarchyHasMultipleRoots = hierarchyHasMultipleRoots;
    }

    @JsonProperty(value="hidden")
    public Boolean isHidden() {
        return this.hidden;
    }

    @JsonProperty(value="hidden")
    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    @JsonProperty(value="sourceCategory")
    public SourceCategory getSourceCategory() {
        return this.sourceCategory;
    }

    @JsonProperty(value="sourceCategory")
    public void setSourceCategory(SourceCategory sourceCategory) {
        this.sourceCategory = sourceCategory;
    }

    @JsonProperty(value="calculation")
    public Boolean isCalculation() {
        return this.calculation;
    }

    @JsonProperty(value="calculation")
    public void setCalculation(Boolean calculation) {
        this.calculation = calculation;
    }

    @JsonProperty(value="facetEnabled")
    public FacetEnabled getFacetEnabled() {
        return this.facetEnabled;
    }

    @JsonProperty(value="facetEnabled")
    public void setFacetEnabled(FacetEnabled facetEnabled) {
        this.facetEnabled = facetEnabled;
    }

    @JsonIgnore
    public String[] getSuggestedStats() {
        return this.suggestedStats;
    }

    @JsonProperty(value="suggestedStats")
    public void setSuggestedStats(String[] stats) {
        this.suggestedStats = stats;
    }

    @JsonProperty(value="isNullable")
    public void setIsNullable(boolean value) {
        this.isNullable = value;
    }

    @JsonIgnore
    public boolean isNullable() {
        return this.isNullable;
    }

    public static enum FacetEnabled {
        AUTOMATIC("automatic"),
        FALSE("false"),
        TRUE("true");

        private final String value;
        private static Map<String, FacetEnabled> constants;

        private FacetEnabled(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static FacetEnabled fromValue(String value) {
            FacetEnabled constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, FacetEnabled>();
            for (FacetEnabled c : FacetEnabled.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum SourceCategory {
        PROPERTY("PROPERTY"),
        LEVEL("LEVEL"),
        HIERARCHY_LEVEL("HIERARCHY_LEVEL"),
        HIERARCHY_PARENT_CHILD("HIERARCHY_PARENT_CHILD"),
        DIMENSION_REGULAR("DIMENSION_REGULAR"),
        DIMENSION_MEASURE("DIMENSION_MEASURE"),
        MEASURE("MEASURE"),
        COLUMN("COLUMN"),
        CALCULATION("CALCULATION"),
        FOLDER("FOLDER"),
        NAMED_SET("NAMED_SET"),
        TABLE("TABLE"),
        VARIABLE("VARIABLE");

        private final String value;
        private static Map<String, SourceCategory> constants;

        private SourceCategory(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SourceCategory fromValue(String value) {
            SourceCategory constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, SourceCategory>();
            for (SourceCategory c : SourceCategory.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum Type {
        ATTRIBUTE("attribute"),
        FACT("fact");

        private final String value;
        private static Map<String, Type> constants;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Type fromValue(String value) {
            Type constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, Type>();
            for (Type c : Type.values()) {
                constants.put(c.value, c);
            }
        }
    }

    public static enum DataType {
        STRING("string"),
        DATE("date"),
        TIME("time"),
        DATETIME("datetime"),
        INTEGER("integer"),
        DOUBLE("double"),
        FLOAT("float"),
        DECIMAL("decimal"),
        BOOLEAN("boolean");

        private final String value;
        private static Map<String, DataType> constants;

        private DataType(String value) {
            this.value = value;
        }

        @JsonValue
        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static DataType fromValue(String value) {
            DataType constant = constants.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            constants = new HashMap<String, DataType>();
            for (DataType c : DataType.values()) {
                constants.put(c.value, c);
            }
        }
    }
}

