/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.api.calculation;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.ibm.bi.qs.model.api.calculation.CalcOperator;
import com.ibm.bi.qs.model.api.calculation.CalcParameter;
import java.util.List;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
@JsonPropertyOrder(value={"op", "params"})
public class CalcExpression
extends CalcParameter {
    @JsonProperty(value="op")
    private CalcOperator operator;
    @JsonProperty(value="params")
    private List<CalcParameter> parameters;

    @JsonProperty(value="op")
    public CalcOperator getOperator() {
        return this.operator;
    }

    @JsonProperty(value="op")
    public void setOperator(CalcOperator operator) {
        this.operator = operator;
    }

    @JsonProperty(value="params")
    public List<CalcParameter> getParams() {
        return this.parameters;
    }

    @JsonProperty(value="params")
    public void setParams(List<CalcParameter> parameters) {
        this.parameters = parameters;
    }

    public String formatExpression(Object[] args) {
        String formatter = this.operator.getFormat(args.length);
        if (formatter == null) {
            String opToken = this.operator.getFormat(-1);
            if (opToken == null) {
                throw new IllegalArgumentException();
            }
            StringBuilder sb = new StringBuilder();
            for (Object value : args) {
                if (sb.length() > 0) {
                    sb.append(opToken);
                }
                sb.append(value);
            }
            return sb.toString();
        }
        return String.format(formatter, args);
    }
}

