/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.api.calculation;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.ibm.bi.qs.model.api.calculation.CalcOperatorFormat;
import java.util.HashMap;
import java.util.Map;

public enum CalcOperator {
    ADD("+", CalcOperatorFormat.ADD),
    SUBTRACT("-", CalcOperatorFormat.SUBTRACT),
    MULTIPLY("*", CalcOperatorFormat.MULTIPLY),
    DIVIDE("/", CalcOperatorFormat.DIVIDE),
    RANKTOP("ranktop", CalcOperatorFormat.RANKTOP, CalcOperatorFormat.RANKTOP_DIM),
    RANKBOTTOM("rankbottom", CalcOperatorFormat.RANKBOTTOM, CalcOperatorFormat.RANKBOTTOM_DIM);

    public static final int VARIABLE_LENGTH = -1;
    private static Map<String, CalcOperator> constants;
    private Map<Integer, CalcOperatorFormat> formats = new HashMap<Integer, CalcOperatorFormat>();
    private final String value;

    private CalcOperator(String value, CalcOperatorFormat ... formats) {
        this.value = value;
        for (CalcOperatorFormat format : formats) {
            this.formats.put(format.getParameterCount(), format);
        }
    }

    @JsonValue
    public String toString() {
        return this.value;
    }

    @JsonCreator
    public static CalcOperator fromValue(String value) {
        CalcOperator constant = constants.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    public String getFormat(int nParams) {
        CalcOperatorFormat format = this.formats.get(nParams);
        if (format == null) {
            return null;
        }
        return format.toString();
    }

    static {
        constants = new HashMap<String, CalcOperator>();
        for (CalcOperator c : CalcOperator.values()) {
            constants.put(c.value, c);
        }
    }
}

