/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.api.data.stats.generated;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum Stat {
    COUNT_DISTINCT("countDistinct"),
    MIN("min"),
    MAX("max"),
    COUNT("count"),
    COUNT_NULL("countNull"),
    APPROX_COUNT_DISTINCT("approxCountDistinct");

    private final String value;
    private static final Map<String, Stat> CONSTANTS;

    private Stat(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    @JsonValue
    public String value() {
        return this.value;
    }

    @JsonCreator
    public static Stat fromValue(String value) {
        Stat constant = CONSTANTS.get(value);
        if (constant == null) {
            throw new IllegalArgumentException(value);
        }
        return constant;
    }

    static {
        CONSTANTS = new HashMap<String, Stat>();
        for (Stat c : Stat.values()) {
            CONSTANTS.put(c.value, c);
        }
    }
}

