/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.marshal;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.ibm.bi.qs.model.api.FieldOrdering;
import com.ibm.bi.qs.model.api.calculation.CalcParameter;
import com.ibm.bi.qs.model.api.data.common.generated.FilterExpression;
import com.ibm.bi.qs.model.marshal.CalcParameterDeserializer;
import com.ibm.bi.qs.model.marshal.FieldOrderingDeserializer;
import com.ibm.bi.qs.model.marshal.FilterExpressionDeserializer;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import javax.enterprise.context.ApplicationScoped;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

@ApplicationScoped
public class ModelFactory
implements Serializable {
    private static final long serialVersionUID = 279845518849047086L;
    private final ObjectMapper objectMapper;
    private static volatile ModelFactory modelFactory;

    public ModelFactory() {
        this(new ObjectMapper());
        this.init();
    }

    private void init() {
        SimpleModule factoryModule = new SimpleModule();
        factoryModule.addDeserializer(FilterExpression.class, (JsonDeserializer)new FilterExpressionDeserializer(this.objectMapper));
        factoryModule.addDeserializer(FieldOrdering.class, (JsonDeserializer)new FieldOrderingDeserializer(this.objectMapper));
        factoryModule.addDeserializer(CalcParameter.class, (JsonDeserializer)new CalcParameterDeserializer(this.objectMapper));
        this.objectMapper.registerModule((Module)factoryModule);
    }

    public static synchronized ModelFactory getInstance() {
        if (modelFactory == null) {
            modelFactory = new ModelFactory();
            return modelFactory;
        }
        return modelFactory;
    }

    ModelFactory(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public boolean isSupported(Class<?> clazz) {
        return this.objectMapper.canSerialize(clazz);
    }

    public <T> T create(JSONObject jsonObject, Class<T> clazz) throws IOException {
        try {
            return (T)this.objectMapper.readValue(jsonObject.write(), clazz);
        }
        catch (JSONException e) {
            throw new JsonGenerationException(e.getMessage(), (Throwable)e);
        }
    }

    public <T> T create(InputStream contentStream, Class<T> clazz) throws IOException {
        return (T)this.objectMapper.readValue(contentStream, clazz);
    }

    public JSONObject create(Object object) throws IOException {
        try {
            return new JSONObject(this.objectMapper.writeValueAsString(object));
        }
        catch (JSONException e) {
            throw new JsonGenerationException(e.getMessage(), (Throwable)e);
        }
    }

    public JSONObject createOrdered(Object object) throws IOException {
        try {
            return new OrderedJSONObject(this.objectMapper.writeValueAsString(object));
        }
        catch (JSONException e) {
            throw new JsonGenerationException(e.getMessage(), (Throwable)e);
        }
    }

    public String toJSON(Object object) throws IOException {
        try {
            return this.objectMapper.writeValueAsString(object);
        }
        catch (Exception e) {
            throw new JsonGenerationException(e.getMessage(), (Throwable)e);
        }
    }
}

