/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bi.qs.model.marshal;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.JsonNodeDeserializer;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;

public class V5JSONNodeDeserializer
extends JsonNodeDeserializer {
    public JsonNode deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        switch (p.currentTokenId()) {
            case 1: {
                return this.customizedObjectDeserializer(p, ctxt, ctxt.getNodeFactory());
            }
            case 3: {
                return this.deserialize(p, ctxt);
            }
        }
        return this.deserialize(p, ctxt);
    }

    protected final ObjectNode customizedObjectDeserializer(JsonParser p, DeserializationContext ctxt, JsonNodeFactory nodeFactory) throws IOException {
        ObjectNode node = nodeFactory.objectNode();
        String key = p.nextFieldName();
        while (key != null) {
            BooleanNode value;
            boolean isXMLAttribute = true;
            JsonToken t = p.nextToken();
            if (t == null) {
                t = JsonToken.NOT_AVAILABLE;
            }
            switch (t.id()) {
                case 1: {
                    isXMLAttribute = false;
                    value = this.customizedObjectDeserializer(p, ctxt, nodeFactory);
                    break;
                }
                case 3: {
                    isXMLAttribute = false;
                    value = this.deserialize(p, ctxt);
                    break;
                }
                case 12: {
                    isXMLAttribute = false;
                    value = this._fromEmbedded(p, ctxt);
                    break;
                }
                case 6: {
                    value = nodeFactory.textNode(p.getText());
                    break;
                }
                case 7: {
                    value = this._fromInt(p, ctxt, nodeFactory);
                    break;
                }
                case 9: {
                    value = nodeFactory.booleanNode(true);
                    break;
                }
                case 10: {
                    value = nodeFactory.booleanNode(false);
                    break;
                }
                case 11: {
                    isXMLAttribute = false;
                    value = nodeFactory.objectNode();
                    break;
                }
                default: {
                    isXMLAttribute = false;
                    value = this.deserialize(p, ctxt);
                }
            }
            JsonNode old = V5JSONNodeDeserializer.refineJSONNode(node, key, (JsonNode)value, isXMLAttribute, nodeFactory);
            if (old != null) {
                this._handleDuplicateField(p, ctxt, nodeFactory, key, node, old, (JsonNode)value);
            }
            key = p.nextFieldName();
        }
        return node;
    }

    public static final JsonNode refineJSONNode(ObjectNode node, String key, JsonNode value, boolean isXMLAttribute, JsonNodeFactory nodeFactory) {
        JsonNode old = null;
        if (key.isEmpty()) {
            old = node.replace("content:", value);
        } else if ("query".equals(key) || "dataItem".equals(key) || "slicerMemberSet".equals(key) || "detailFilter".equals(key) || "memberSet".equals(key) || "queryResultDefinition".equals(key) || "edge".equals(key) || "edgeGroup".equals(key) || "valueSet".equals(key) || "groupBody".equals(key) || "dataItemRef".equals(key) || "propertyExpression".equals(key) || "groupSort".equals(key) || "sortItem".equals(key)) {
            JsonNode array = node.get(key);
            if (null == array) {
                array = nodeFactory.arrayNode();
                ((ArrayNode)array).add(value);
                old = node.replace(key, array);
            } else {
                old = array;
            }
        } else if (isXMLAttribute && !"expression".equals(key) && !"filterExpression".equals(key) && !"modelPath".equals(key)) {
            if (!"attr:forREST".equals("attr:" + key)) {
                old = node.replace("attr:" + key, value);
            }
        } else {
            old = "querySet".equals(key) ? node.replace("v5QuerySet", value) : node.replace(key, value);
        }
        return old;
    }
}

