/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.config.ConfigException;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQECCLConfigurationAdapter;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationEvent;
import com.cognos.xqe.config.XQEConfigurationListener;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.config.XQESubConfiguration;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.SingletonHelper;

public final class TM1RESTConfig
implements XQEConfigurationListener {
    private static final String STR_LOAD_ERR = "Error loading XQEODP configuration: ";
    private boolean isRegistered = false;
    private static SingletonHelper<TM1RESTConfig> singletonHelper = new SingletonHelper<TM1RESTConfig>(){

        protected TM1RESTConfig newInstance() {
            return new TM1RESTConfig();
        }

        protected void releaseImpl(TM1RESTConfig theInstance) {
        }

        protected void initializeImpl(TM1RESTConfig theInstance) {
        }
    };

    private TM1RESTConfig() {
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONFIGURATION_TM1PROVIDER, LogLevel.TRACE, "Constructing TM1RESTConfig", new Object[0]);
        this.reload();
    }

    public static TM1RESTConfig instance() {
        return (TM1RESTConfig)singletonHelper.getInstance();
    }

    public void configurationChanged(XQEConfigurationEvent e) {
        if (e.isBeforeUpdate() || e.getType() != 20) {
            return;
        }
        this.reload();
    }

    public void reload() {
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONFIGURATION_TM1PROVIDER, LogLevel.TRACE, "Loading TM1Config", new Object[0]);
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQEODP);
        if (config == null) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONFIGURATION_TM1PROVIDER, LogLevel.TRACE, "Constructing new XQEConfiguration instance for XQEODP", new Object[0]);
            try {
                config = XQECCLConfigurationAdapter.createDefaultConfigurationForService((ServiceEnumeration)ServiceEnumeration.XQEODP);
                XQEConfigurationManager.getInstance().add(ServiceEnumeration.XQEODP, config);
                config.registerConfigurationListener((XQEConfigurationListener)this);
                this.isRegistered = true;
            }
            catch (ConfigException ce) {
                if (XQEMessageKeys.CFG_FileExistError == ce.getMessageKey()) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONFIGURATION_TM1PROVIDER, LogLevel.WARN, ce, STR_LOAD_ERR, new Object[0]);
                } else {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONFIGURATION_TM1PROVIDER, LogLevel.ERROR, ce, STR_LOAD_ERR, new Object[0]);
                }
                return;
            }
        } else if (!this.isRegistered) {
            config.registerConfigurationListener((XQEConfigurationListener)this);
            this.isRegistered = true;
        }
        XQESubConfiguration tm1Config = config.getConfigForXQEODPComponent("TMR");
        if (tm1Config != null) {
            tm1Config.next();
        }
        this.writeToLog();
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void writeToLog() {
    }
}

