/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.ast.olap.MDXQuery;
import com.cognos.xqe.bibushandler.datasource.ProviderCapabilites;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.model.CapabilitiesKey;
import com.cognos.xqe.data.model.CapabilitiesKeyParts;
import com.cognos.xqe.data.model.IDataSource;
import com.cognos.xqe.data.model.IDataSourceCapabilities;
import com.cognos.xqe.data.model.IDataSourceConnection;
import com.cognos.xqe.data.model.LogonFailureException;
import com.cognos.xqe.data.olap.common.CAMPassportParameter;
import com.cognos.xqe.data.providers.ConnectionTestQueryArguments;
import com.cognos.xqe.data.providers.connection.ConnectionFactoryStatisticsDecorator;
import com.cognos.xqe.data.providers.connection.parameters.UserClassIDsParameter;
import com.cognos.xqe.data.providers.olap.IOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.MetadataQueryArguments;
import com.cognos.xqe.data.providers.olap.OLAPDataProviderBase;
import com.cognos.xqe.data.providers.olap.TracingOLAPMetadataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnectionFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMetadataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTServerSecurity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.ConnectionParameterHelper;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTAdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTConnectionSelector;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerNameParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTMDXQuery;
import com.cognos.xqe.exception.XQEMessage;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionFactory;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.pool.connection.IConnectionPool;
import com.cognos.xqe.pool.connection.IConnectionSelector;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.TestEnvironmentOptions;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.trace.LogLevel;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Element;

public class TM1RESTDataProvider
extends OLAPDataProviderBase {
    private static final String DOT = ".";
    private static final String NATIVE_TM1_QUERY = "NativeTM1Query:";
    private static final String USE_PXJ_THRESHOLD = "UseProviderCrossJoinThreshold";
    private static final String USE_PXJ_THRESHOLD_VALUE = "10000";
    private static final String USE_PXJ_THRESHOLD_KEY = "queryExecution.useProviderCrossJoinThreshold[@value]";
    private static final String PXJ_NOT_SET_MSG = "UseProviderCrossJoinThreshold will not be set on the mdquery.";
    private static final String INITIAL_CONNECTION_EXPIRATION_THRESHOLD = "initialConnectionExpirationThreshold";
    private static final long DEFAULT_INITIAL_CONNECTION_EXPIRATION_THRESHOLD = 10000L;
    public static final int DEFAULT_NGTM1_CONNECTION_EXPIRATION_CHECK_PERIOD = 10000;
    private static final Properties DEFAULT_NGTM1_PROPERTIES = TM1RESTDataProvider.makeDefaultNGTM1Properties();
    private static final String TM1_VERSION_10_1_CAPABILITY = "10.1";
    private static final String TM1_VERSION_10_1_1_CAPABILITY = "10.1.1";
    public static final String USER_GROUP_KEY = "%s:%s:%s";
    private final TM1RESTConnectionFactory mTM1ConnectionFactory = new TM1RESTConnectionFactory(this);
    private final IConnectionFactory mConnectionFactory;

    public TM1RESTDataProvider(String instanceName, Properties properties) {
        super(instanceName, properties, (IConnectionSelector)new TM1RESTConnectionSelector());
        this.mConnectionFactory = new ConnectionFactoryStatisticsDecorator((IConnectionFactory)this.mTM1ConnectionFactory, instanceName);
    }

    protected Properties getDefaultProperties(Properties properties) {
        Properties defaultProperties = super.getDefaultProperties(properties);
        defaultProperties.putAll((Map<?, ?>)DEFAULT_NGTM1_PROPERTIES);
        return properties;
    }

    protected static Properties makeDefaultNGTM1Properties() {
        Properties properties = new Properties();
        properties.setProperty("connectionExpirationCheckPeriod", Integer.toString(10000));
        properties.setProperty(INITIAL_CONNECTION_EXPIRATION_THRESHOLD, Long.toString(10000L));
        return properties;
    }

    public ICubeResultSet query(XDataContext xDataContext, MDXQueryArguments theQueryArguments) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)xDataContext.getEnvironment();
        ConnectionParameters connParams = this.createConnectionParameters((IExecutionEnvironment)execEnv, theQueryArguments);
        try {
            IPooledConnection pooledConn = this.borrowConnection(connParams, (IExecutionEnvironment)execEnv);
            TM1RESTConnection tm1Conn = (TM1RESTConnection)((Object)pooledConn.getConnection());
            MDXQuery mdxQuery = theQueryArguments.getMDXQuery();
            String queryString = mdxQuery.getMDX().replaceFirst(NATIVE_TM1_QUERY, "");
            try {
                TM1RESTMDXQuery query = new TM1RESTMDXQuery(tm1Conn, execEnv);
                String cellSetID = query.execute(queryString, mdxQuery.getReferencedCube());
                TM1RESTCubeResultSet resultSet = new TM1RESTCubeResultSet(this, pooledConn, xDataContext, theQueryArguments, cellSetID);
                resultSet.initialize(theQueryArguments);
                return resultSet;
            }
            catch (RuntimeException ex) {
                pooledConn.returnConnection();
                throw ex;
            }
        }
        catch (LogonFailureException ex) {
            if (ex.getDataSource() == null) {
                ex.setDataSource(theQueryArguments.getDataSource());
            }
            IDataSource dataSource = theQueryArguments.getDataSource();
            IDataSourceConnection dsConnection = dataSource.getDataSourceConnection();
            dsConnection.invalidateResolvedSignon();
            throw ex;
        }
    }

    private static String getPXJThresholdValue(MDXQuery mdxQuery, String mdquery) {
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        Boolean pxjEnabledProperty = mdxQuery.getBooleanPropertyValue("PXJEnabled");
        if (pxjEnabledProperty != null) {
            if (pxjEnabledProperty.booleanValue()) {
                String pxjSetting = config.getStringProperty(USE_PXJ_THRESHOLD_KEY, USE_PXJ_THRESHOLD_VALUE);
                if (TM1RESTLog.DATA_SUPPRESS_PXJ.isOn(LogLevel.INFO)) {
                    StringBuilder sb = new StringBuilder("PXJEnabled is set to \"true\" on the MDXQuery node. ");
                    sb.append("Setting UseProviderCrossJoinThreshold on the mdquery to ").append(pxjSetting).append(DOT);
                    TM1RESTLog.DATA_SUPPRESS_PXJ.log(LogLevel.INFO, sb.toString());
                }
                return pxjSetting;
            }
            TM1RESTLog.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, "PXJEnabled is set to \"false\" on the MDXQuery node. UseProviderCrossJoinThreshold will not be set on the mdquery.");
            return null;
        }
        if (Boolean.FALSE.equals(mdxQuery.getNullSuppressionQueryHint())) {
            TM1RESTLog.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, "The property 'nullSuppressionAcrossEdges' is set to \"false\" on the MDXQuery node. UseProviderCrossJoinThreshold will not be set on the mdquery.");
            return null;
        }
        String pxjThresholdSetting = config.getStringProperty(USE_PXJ_THRESHOLD_KEY, null);
        if (pxjThresholdSetting == null) {
            if (TM1RESTLog.DATA_SUPPRESS_PXJ.isOn(LogLevel.TRACE)) {
                StringBuilder sb = new StringBuilder("There is no entry for ").append(USE_PXJ_THRESHOLD_KEY);
                sb.append(" in XQE's configuration file. ").append(PXJ_NOT_SET_MSG);
                TM1RESTLog.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, sb.toString());
            }
            return null;
        }
        if (!mdquery.contains("<suppressNulls")) {
            TM1RESTLog.DATA_SUPPRESS_PXJ.log(LogLevel.TRACE, "There is no <suppressNulls/> clause in the mdquery. UseProviderCrossJoinThreshold will not be set on the mdquery.");
            return null;
        }
        if (TM1RESTLog.DATA_SUPPRESS_PXJ.isOn(LogLevel.INFO)) {
            StringBuilder sb = new StringBuilder(USE_PXJ_THRESHOLD);
            sb.append(" will be set to ").append(pxjThresholdSetting).append(" on the mdquery.");
            TM1RESTLog.DATA_SUPPRESS_PXJ.log(LogLevel.INFO, sb.toString());
        }
        return pxjThresholdSetting;
    }

    protected static ConnectionParameters createConnectionParams(IExecutionEnvironment env, MDXQueryArguments args) {
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters((ExecutionEnvironment)env, connectionElement, args.getDataSource(), args.getRunLocale());
    }

    public ConnectionParameters createConnectionParameters(IExecutionEnvironment env, MDXQueryArguments queryArgs) {
        return TM1RESTDataProvider.createConnectionParams(env, queryArgs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XQEMessage> testConnection(ConnectionTestQueryArguments theQueryArguments) {
        List<XQEMessage> connectionDetails = null;
        TM1RESTConnection connection = null;
        try {
            connection = (TM1RESTConnection)((Object)this.mTM1ConnectionFactory.createConnection(TM1RESTDataProvider.createConnectionParams(theQueryArguments)));
            connectionDetails = connection.getConnectionDetails();
            this.mTM1ConnectionFactory.destroyConnection(connection);
        }
        catch (Throwable throwable) {
            this.mTM1ConnectionFactory.destroyConnection(connection);
            throw throwable;
        }
        return connectionDetails;
    }

    protected static ConnectionParameters createConnectionParams(MetadataQueryArguments args) {
        ExecutionEnvironment env = (ExecutionEnvironment)args.getExecutionEnvironment();
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getDesignLocale());
    }

    protected static ConnectionParameters createConnectionParams(ConnectionTestQueryArguments args) {
        ExecutionEnvironment env = (ExecutionEnvironment)args.getExecutionEnvironment();
        Element connectionElement = env.getConnectionElement();
        return ConnectionParameterHelper.constructConnectionParameters(env, connectionElement, args.getDataSource(), args.getRunLocale());
    }

    public IOLAPMetadataProvider getMetadataProvider(MetadataQueryArguments theQueryArguments) {
        Locale metadataLocale = theQueryArguments.getDesignLocale();
        try {
            TM1RESTMetadataProvider provider = new TM1RESTMetadataProvider(this, metadataLocale, TM1RESTDataProvider.createConnectionParams(theQueryArguments));
            provider = new TracingOLAPMetadataProvider((IOLAPMetadataProvider)provider, "TM1REST");
            return provider;
        }
        catch (LogonFailureException e) {
            if (e.getDataSource() == null) {
                e.setDataSource(theQueryArguments.getDataSource());
            }
            throw e;
        }
    }

    public IConnectionFactory getConnectionFactory() {
        return this.mConnectionFactory;
    }

    public IConnectionSelector getConnectionSelector(String providerType, Object securityContext) {
        return this.selector;
    }

    public IPooledConnection borrowConnection(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        if (null == executionEnvironment) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        if (TM1RESTServerSecurity.securityModeRequiresCAM(connectionParameters)) {
            String cachedUserGroups = TM1RESTServerSecurity.getCachedTM1ServerUserGroups(connectionParameters, executionEnvironment);
            if (null != cachedUserGroups) {
                connectionParameters.put((IConnectionParameter)new UserClassIDsParameter(cachedUserGroups, true));
            } else {
                CAMPassportParameter camPassport = (CAMPassportParameter)connectionParameters.get(CAMPassportParameter.class);
                if (null != camPassport && !camPassport.isMatchable()) {
                    connectionParameters.put((IConnectionParameter)new CAMPassportParameter((String)camPassport.value(), true));
                }
            }
        }
        IConnectionPool pool = executionEnvironment.getConnectionPool();
        String providerName = this.getProviderInstanceName();
        IConnectionFactory factory = this.getConnectionFactory();
        IPooledConnection pooledConnection = null;
        TM1RESTConnection connection = null;
        boolean connectionNotFound = true;
        while (connectionNotFound) {
            pooledConnection = pool.borrowConnection(providerName, connectionParameters, this.selector, factory);
            connection = (TM1RESTConnection)((Object)pooledConnection.getConnection());
            boolean isValid = true;
            boolean validationExecuted = false;
            if (connection.needValidation()) {
                isValid = connection.isValid();
                validationExecuted = true;
            }
            Integer connectionId = System.identityHashCode((Object)connection);
            if (!isValid) {
                connection.invalidate();
                connection.returnToPool();
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.WARN, "[CONNECTION_ID=%d] Validation failed connnect invalidated", connectionId);
                continue;
            }
            connectionNotFound = false;
            if (!validationExecuted) continue;
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SELECTOR, LogLevel.INFO, "[CONNECTION_ID=%d] Validation passed connnect validated", connectionId);
        }
        connection.setPooledConnection(pooledConnection);
        return pooledConnection;
    }

    protected void releaseImpl() {
        this.mTM1ConnectionFactory.dispose();
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.INIT_TERM_TM1PROVIDER, LogLevel.WARN, "Disposed the TM1 REST data provider.", new Object[0]);
        boolean doNothing = true;
        if (doNothing) {
            return;
        }
    }

    public void resolveDataSourceCapabilities(IExecutionEnvironment executionEnv, IDataSource dataSource, Locale designLocale) {
        MetadataQueryArguments queryArgs = new MetadataQueryArguments(dataSource, executionEnv, designLocale);
        ConnectionParameters connParams = TM1RESTDataProvider.createConnectionParams(queryArgs);
        IPooledConnection pooledConnection = this.borrowConnection(connParams, executionEnv);
        String version = null;
        XQEConfiguration config = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        boolean forceDatabaseOnlyForPA = false;
        if (config != null) {
            forceDatabaseOnlyForPA = config.getBooleanProperty("ForceDatabaseOnlyForPA", false);
        }
        boolean bDataBaseOnly = executionEnv.getMultiRequestContext().getRequestProcessing() == MultiRequestContext.RequestProcessing.DATABASEONLY;
        version = forceDatabaseOnlyForPA || bDataBaseOnly ? TM1_VERSION_10_1_CAPABILITY : TM1_VERSION_10_1_1_CAPABILITY;
        pooledConnection.returnConnection();
        CapabilitiesKey key = ProviderCapabilites.createCapabilitiesKey((IDataSource)dataSource, (String)version);
        IDataSourceCapabilities dataSourceCapabilities = ProviderCapabilites.getInstance().getCapabilities(key);
        dataSource.setCapabilities(dataSourceCapabilities);
        if (null == dataSourceCapabilities) {
            IDataSourceCapabilities modifiableCapabilities;
            dataSourceCapabilities = dataSource.createCapabilities(new CapabilitiesKeyParts(version), null);
            ProviderCapabilites.getInstance().addCapabilities(key, dataSourceCapabilities);
            TestEnvironmentOptions testEnvironmentOptions = executionEnv.getTestEnvironmentOptions();
            if (testEnvironmentOptions != null && (modifiableCapabilities = testEnvironmentOptions.getModifiableCapabilities()) != null) {
                modifiableCapabilities.modify(dataSourceCapabilities);
            }
        }
    }

    public Object getCubeUniqueId(ConnectionParameters params, MDXQueryArguments args) {
        TM1RESTAdminHostParameter adminHost = (TM1RESTAdminHostParameter)params.get(TM1RESTAdminHostParameter.class);
        if (adminHost != null) {
            TM1RESTServerNameParameter server = (TM1RESTServerNameParameter)params.get(TM1RESTServerNameParameter.class);
            String cubeName = args.getCube().getName();
            LinkedList<Object> key = new LinkedList<Object>();
            key.add(adminHost.value());
            key.add(server.value());
            key.add(cubeName);
            return key;
        }
        return null;
    }

    public Object getSecurityContext(ConnectionParameters params) {
        if (TM1RESTConnection.securityModeHasUserGroups(params)) {
            return TM1RESTConnection.addStaticUserGroups(params);
        }
        return null;
    }
}

