/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest;

import com.cognos.xqe.data.providers.connection.parameters.CAMCryptoHandleParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.SecurityModeData;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.UserGroupsData;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.CMUserIdentity;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTAdminHostParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.connection.TM1RESTServerPortParameter;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1CubeSnapshot;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientConfig;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.concurrent.Gate;
import com.cognos.xqe.util.eviction.ConcurrentSimpleDLinkLRUMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpRequestBase;

public final class TM1RESTServerSecurity {
    private static final String CACHED_USER_GROUPS_FOR_THE_KEYED_CONNECTION = "Cached user groups for the keyed connection [%s] are [%s].";
    private static final String CACHED_SECURITY_MODE_FOR_THE_KEYED_CONNECTION = "Cached security mode for the keyed connection [%s] is [%s].";
    private static final String FAILED_TO_GET_THE_RESOURCE_REASON = "Failed to get the resource [%s]. Reason=[%s].";
    private static final long SEC_MODE_GATE_WAIT_TIME = 10L;
    private static final ConcurrentHashMap<String, Gate> SEC_MODE_GATE = new ConcurrentHashMap();
    private static final String SERVER_ID_KEY = "%s:%s";
    private static final int USER_GROUP_CACHE_SIZE = 4096;
    private static final String USER_GROUP_SEPARATOR = ";";
    public static final String USER_GROUP_KEY = "%s:%s:%s";
    private static final long USER_GROUP_GATE_WAIT_TIME = 10L;
    private static final ConcurrentHashMap<String, Gate> USER_GROUP_GATE = new ConcurrentHashMap();
    protected static ConcurrentMap<String, SecurityModeData> serverToSecurityModeDataMap = new ConcurrentHashMap<String, SecurityModeData>();
    protected static ConcurrentSimpleDLinkLRUMap<String, UserGroupsData> serverCAMToUserGroupsDataMap = new ConcurrentSimpleDLinkLRUMap(4096, true);
    List<String> userGroupsToRemove = new ArrayList<String>();
    private static final ConcurrentHashMap<String, Gate> CUBE_TIMESTAMPS_GATE = new ConcurrentHashMap();
    private static final long CUBE_TIMESTAMPS_WAIT_TIME = 5L;
    protected static ConcurrentMap<String, TM1CubeSnapshot> serverHostCubeSnapshotMap = new ConcurrentHashMap<String, TM1CubeSnapshot>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityMode getStaticTM1ServerSecurityMode(ConnectionParameters connectionParameters) {
        int serverPort;
        SecurityMode securityMode = SecurityMode.BASIC;
        String serverAdminHost = (String)connectionParameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        String adminServerKey = TM1RESTServerSecurity.getServerIdKey(serverAdminHost, Integer.toString(serverPort = connectionParameters.intValueOf(TM1RESTServerPortParameter.class, 8001)));
        SecurityModeData securityModeData = (SecurityModeData)serverToSecurityModeDataMap.get(adminServerKey);
        if (null == securityModeData) {
            Gate newGate = new Gate();
            newGate.close();
            Gate gate = SEC_MODE_GATE.putIfAbsent(adminServerKey, newGate);
            if (gate != null) {
                try {
                    gate.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                securityModeData = (SecurityModeData)serverToSecurityModeDataMap.get(adminServerKey);
            }
            try {
                if (null == securityModeData) {
                    securityMode = TM1RESTServerSecurity.getSecurityModes(connectionParameters);
                    serverToSecurityModeDataMap.putIfAbsent(adminServerKey, new SecurityModeData(securityMode));
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SECURITY_MODE, LogLevel.TRACE, "New security mode for the keyed connection [%s] is [%s].", adminServerKey, securityMode.toString());
                }
            }
            finally {
                gate = SEC_MODE_GATE.remove(adminServerKey);
                if (gate != null) {
                    gate.open();
                }
            }
        }
        if (null != securityModeData) {
            securityMode = securityModeData.getMode();
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SECURITY_MODE, LogLevel.TRACE, CACHED_SECURITY_MODE_FOR_THE_KEYED_CONNECTION, adminServerKey, securityMode.toString());
        }
        return securityMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SecurityMode resetStaticTM1ServerSecurityMode(String serverHost, int serverPort, SecurityMode securityMode) {
        SecurityMode newSecurityMode;
        String adminServerKey = TM1RESTServerSecurity.getServerIdKey(serverHost, Integer.toString(serverPort));
        SecurityModeData securityModeData = null;
        Gate newGate = new Gate();
        newGate.close();
        Gate gate = SEC_MODE_GATE.putIfAbsent(adminServerKey, newGate);
        if (gate != null) {
            try {
                gate.await(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            securityModeData = (SecurityModeData)serverToSecurityModeDataMap.get(adminServerKey);
        }
        try {
            if (null == securityModeData) {
                serverToSecurityModeDataMap.put(adminServerKey, new SecurityModeData(securityMode));
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SECURITY_MODE, LogLevel.TRACE, "Reset security mode for the keyed connection [%s] is [%s].", adminServerKey, securityMode.toString());
            }
        }
        finally {
            gate = SEC_MODE_GATE.remove(adminServerKey);
            if (gate != null) {
                gate.open();
            }
        }
        if (null != securityModeData) {
            newSecurityMode = securityModeData.getMode();
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SECURITY_MODE, LogLevel.TRACE, CACHED_SECURITY_MODE_FOR_THE_KEYED_CONNECTION, adminServerKey, securityMode.toString());
        } else {
            newSecurityMode = securityMode;
        }
        return newSecurityMode;
    }

    public static TM1CubeSnapshot getCubeSnapshot(String serverCubeKey) {
        return (TM1CubeSnapshot)serverHostCubeSnapshotMap.get(serverCubeKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TM1CubeSnapshot getOrSetCubeSnapshot(String serverCubeKey, TM1CubeSnapshot cubeSnapshot) {
        TM1CubeSnapshot cachedCubeSnapshot = (TM1CubeSnapshot)serverHostCubeSnapshotMap.get(serverCubeKey);
        if (cachedCubeSnapshot != null) {
            return cachedCubeSnapshot;
        }
        Gate newGate = new Gate();
        newGate.close();
        Gate gate = CUBE_TIMESTAMPS_GATE.putIfAbsent(serverCubeKey, newGate);
        if (gate != null) {
            try {
                gate.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cachedCubeSnapshot = (TM1CubeSnapshot)serverHostCubeSnapshotMap.get(serverCubeKey);
        }
        try {
            if (null == cachedCubeSnapshot && null == (cachedCubeSnapshot = serverHostCubeSnapshotMap.putIfAbsent(serverCubeKey, cubeSnapshot))) {
                cachedCubeSnapshot = cubeSnapshot;
            }
        }
        finally {
            gate = CUBE_TIMESTAMPS_GATE.remove(serverCubeKey);
            if (gate != null) {
                gate.open();
            }
        }
        return cachedCubeSnapshot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TM1CubeSnapshot setCubeSnapshot(String serverCubeKey, TM1CubeSnapshot cubeSnapshot) {
        TM1CubeSnapshot cachedCubeSnapshot = null;
        Gate newGate = new Gate();
        newGate.close();
        Gate gate = CUBE_TIMESTAMPS_GATE.putIfAbsent(serverCubeKey, newGate);
        if (gate != null) {
            try {
                gate.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            cachedCubeSnapshot = (TM1CubeSnapshot)serverHostCubeSnapshotMap.get(serverCubeKey);
        }
        try {
            if (null == cachedCubeSnapshot) {
                serverHostCubeSnapshotMap.put(serverCubeKey, cubeSnapshot);
                cachedCubeSnapshot = cubeSnapshot;
            }
        }
        finally {
            gate = CUBE_TIMESTAMPS_GATE.remove(serverCubeKey);
            if (gate != null) {
                gate.open();
            }
        }
        return cachedCubeSnapshot;
    }

    private static String getServerIdKey(String adminHost, String port) {
        return String.format(SERVER_ID_KEY, adminHost, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SecurityMode getSecurityModes(ConnectionParameters connectionParameters) {
        SecurityMode securityMode = SecurityMode.BASIC;
        RESTClientConfig restClientConfig = new RESTClientConfig(connectionParameters);
        if (restClientConfig.needsOAuth2Authentication()) {
            return SecurityMode.OAUTH2;
        }
        RESTClient restClient = RESTClientFactory.getInstance().getClient(restClientConfig);
        restClient.setAuthorizationParameters("", "", "", "", "", null, null, "");
        restClient.getConfig().setIntegratedSecurityMode(SecurityMode.BASIC);
        restClient.setRequestHeader("Authorization", "Basic ");
        ODataUriBuilder uriBuilder = restClient.getUriBuilder();
        uriBuilder.entity("Cubes").entity("$count");
        HttpRequestBase method = restClient.createGetRequest(uriBuilder.toString());
        RESTClientResponse clientResponse = null;
        try {
            clientResponse = restClient.executeMethod(method, false, false);
            if (clientResponse.getStatusCode() >= 401L) {
                securityMode = TM1RESTServerSecurity.getSecurityModeFromHeader(restClient, clientResponse);
            }
            if (clientResponse.getStatusCode() == 200L || clientResponse.getStatusCode() == 403L) {
                securityMode = SecurityMode.OIDC;
            }
        }
        catch (IOException e) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SECURITY_MODE, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_REASON, uriBuilder.toString(), e.getLocalizedMessage());
        }
        finally {
            if (clientResponse != null) {
                clientResponse.close();
            }
            restClient.close();
        }
        return securityMode;
    }

    public static SecurityMode getSecurityModeFromHeader(RESTClient restClient, RESTClientResponse response) {
        SecurityMode securityMode = SecurityMode.BASIC;
        Header[] headers = response.getResponseHeaders("WWW-Authenticate");
        for (int headerCount = 0; headerCount < headers.length; ++headerCount) {
            String value = headers[headerCount].getValue();
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_PARAMETERS, LogLevel.TRACE, "WWW-Authenticate= '[%s]'", value);
            if (value.startsWith("CAMPassport")) {
                return SecurityMode.CAM;
            }
            if (value.startsWith("Bearer")) {
                return SecurityMode.OIDC;
            }
            if ("Basic realm=\"TM1\"".equals(value)) {
                if (headerCount == 0) {
                    securityMode = SecurityMode.BASIC;
                    continue;
                }
                if (securityMode == SecurityMode.WIA) {
                    securityMode = SecurityMode.MIXED_WIA;
                    continue;
                }
                throw new TM1RESTODPException(TM1RESTMessageKeys.CON_UNSUPPORTED_SIGNON_TYPE, restClient.getConfig().getServer());
            }
            if (!"Negotiate".equals(value)) continue;
            if (headerCount == 0) {
                securityMode = SecurityMode.WIA;
                continue;
            }
            if (securityMode == SecurityMode.BASIC) {
                securityMode = SecurityMode.MIXED_BASIC;
                continue;
            }
            throw new TM1RESTODPException(TM1RESTMessageKeys.CON_UNSUPPORTED_SIGNON_TYPE, restClient.getConfig().getServer());
        }
        return securityMode;
    }

    public static boolean securityModeRequiresCAM(ConnectionParameters parameters) {
        String adminHost = (String)parameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        int serverPort = parameters.intValueOf(TM1RESTServerPortParameter.class, 8001);
        if (-2 == serverPort) {
            return true;
        }
        SecurityMode mode = TM1RESTServerSecurity.getStaticTM1ServerSecurityMode(parameters);
        return TM1RESTServerSecurity.securityModeRequiresCAM(mode, adminHost, Integer.toString(serverPort), parameters);
    }

    private static boolean securityModeRequiresCAM(SecurityMode mode, String adminHost, String serverName, ConnectionParameters parameters) {
        switch (mode) {
            case BASIC: 
            case MIXED_BASIC: {
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "CAM authenticaion for the host [%s] and server [%s] mode [%s] is not supported.", adminHost, serverName, mode.toString());
                return false;
            }
            case WIA: 
            case MIXED_WIA: {
                String ssoDelegationHandle = (String)parameters.valueOf(CAMCryptoHandleParameter.class, String.class);
                if (ssoDelegationHandle != null) break;
                TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "CAM authenticaion for the host [%s] and server [%s] mode [%s] is unsupported.", adminHost, serverName, mode.toString());
                return false;
            }
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "CAM authenticaion for the host [%s] and server [%s] mode [%s] is supported.", adminHost, serverName, mode.toString());
        return true;
    }

    static String getCachedTM1ServerUserGroups(String serverAdminHost, String serverPort, String camPassport) {
        String userGroupsKey = String.format(USER_GROUP_KEY, serverAdminHost, serverPort, camPassport);
        UserGroupsData userGroupsData = (UserGroupsData)serverCAMToUserGroupsDataMap.get((Object)userGroupsKey);
        String userGroups = null;
        if (null != userGroupsData) {
            userGroups = userGroupsData.getUserGroups();
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, CACHED_USER_GROUPS_FOR_THE_KEYED_CONNECTION, userGroupsKey, userGroups);
        return userGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getCachedTM1ServerUserGroups(ConnectionParameters connectionParameters, IExecutionEnvironment executionEnvironment) {
        String serverAdminHost = (String)connectionParameters.valueOf(TM1RESTAdminHostParameter.class, String.class);
        int serverPort = connectionParameters.intValueOf(TM1RESTServerPortParameter.class, 8001);
        String camPassport = executionEnvironment.getRequestEnvironment().getCAMPassport();
        SecurityMode securityMode = TM1RESTServerSecurity.getStaticTM1ServerSecurityMode(connectionParameters);
        String userGroupsKey = String.format(USER_GROUP_KEY, serverAdminHost, Integer.toString(serverPort), camPassport);
        UserGroupsData userGroupsData = (UserGroupsData)serverCAMToUserGroupsDataMap.get((Object)userGroupsKey);
        String userGroups = null;
        if (null == userGroupsData) {
            Gate newGate = new Gate();
            newGate.close();
            Gate gate = USER_GROUP_GATE.putIfAbsent(userGroupsKey, newGate);
            if (gate != null) {
                try {
                    gate.await(10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                userGroups = TM1RESTServerSecurity.getCachedTM1ServerUserGroups(serverAdminHost, Integer.toString(serverPort), camPassport);
            }
            try {
                Object[] userGroupArray;
                if (null == userGroups && null != (userGroupArray = TM1RESTServerSecurity.getSecurityGroups(connectionParameters, securityMode, executionEnvironment))) {
                    String newUserGroupsList = StringUtils.join((Object[])userGroupArray, (String)USER_GROUP_SEPARATOR);
                    userGroupsData = new UserGroupsData(newUserGroupsList);
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, "New user groups for the keyed connection [%s] are [%s].", userGroupsKey, newUserGroupsList);
                    serverCAMToUserGroupsDataMap.putIfAbsent((Object)userGroupsKey, (Object)userGroupsData);
                }
            }
            finally {
                gate = USER_GROUP_GATE.remove(userGroupsKey);
                if (gate != null) {
                    gate.open();
                }
            }
        }
        if (null != userGroupsData) {
            userGroups = userGroupsData.getUserGroups();
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_USER_GROUPS, LogLevel.TRACE, CACHED_USER_GROUPS_FOR_THE_KEYED_CONNECTION, userGroupsKey, userGroups);
        return userGroups;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getSecurityGroups(ConnectionParameters connectionParameters, SecurityMode securityMode, IExecutionEnvironment execEnv) {
        CMUserIdentity cmUserIdentity;
        RESTClientConfig restClientConfig = new RESTClientConfig(connectionParameters);
        restClientConfig.setIntegratedSecurityMode(securityMode);
        RESTClient restClient = RESTClientFactory.getInstance().getClient(restClientConfig);
        restClient.setAuthorizationParameters(connectionParameters, execEnv);
        restClient.setAuthorization();
        String userIdentity = (String)connectionParameters.valueOf(CMUserIdentity.class, String.class);
        if (SecurityMode.OIDC == securityMode && (cmUserIdentity = (CMUserIdentity)connectionParameters.get(CMUserIdentity.class)) != null) {
            userIdentity = cmUserIdentity.getDefaultName();
        }
        ODataUriBuilder uriBuilder = restClient.getUriBuilder();
        uriBuilder.entity("ActiveUser").entity("Groups");
        HttpRequestBase method = restClient.createGetRequest(uriBuilder.toString());
        RESTClientResponse clientResponse = null;
        String[] userGroupsArray = null;
        try {
            clientResponse = restClient.executeMethod(method, false);
            long statusCode = clientResponse.getStatusCode();
            if (200L == statusCode || 201L == statusCode) {
                IJsonObject jsonResponse = clientResponse.getJSONResponse();
                IJsonArray jsonGroupArray = jsonResponse.getArray("value");
                userGroupsArray = new String[jsonGroupArray.size()];
                int i = 0;
                for (Object obj : jsonGroupArray) {
                    userGroupsArray[i++] = ((IJsonObject)obj).getStringValue("Name");
                }
            }
        }
        catch (IOException e) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.CONN_SECURITY_MODE, LogLevel.ERROR, FAILED_TO_GET_THE_RESOURCE_REASON, uriBuilder.toString(), e.getLocalizedMessage());
        }
        finally {
            if (clientResponse != null) {
                clientResponse.close();
            }
            restClient.closeTM1Session();
            restClient.close();
        }
        return userGroupsArray;
    }

    public static enum SecurityMode {
        BASIC,
        MIXED_BASIC,
        MIXED_WIA,
        WIA,
        CAM,
        DISTRIBUTED,
        OIDC,
        OAUTH2;

    }
}

