/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.connection;

import com.cognos.xqe.bibushandler.IRequestEnvironment;
import com.cognos.xqe.bibushandler.content.ContentManager;
import com.cognos.xqe.bibushandler.content.ICMSessionIdentity;
import com.cognos.xqe.bibushandler.content.ICMUser;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.pool.connection.AbstractConnectionParameter;
import com.cognos.xqe.pool.connection.ConnectionParameters;
import com.cognos.xqe.pool.connection.IConnectionParameter;
import com.cognos.xqe.query.engine.IExecutionEnvironment;
import com.cognos.xqe.util.ParameterMapCM;
import java.util.ArrayList;
import java.util.List;

public class CMUserIdentity
extends AbstractConnectionParameter<String> {
    private static final String ACCOUNT = "account";
    private final String mDefaultName;

    public CMUserIdentity(String userIdentity, String name, boolean matchablePassport) {
        super("CM_USER_IDENTITY", (Object)userIdentity, false, matchablePassport);
        this.mDefaultName = name;
    }

    public String getDefaultName() {
        return this.mDefaultName;
    }

    public static void resolveCMUserIdentity(IExecutionEnvironment env, ConnectionParameters params, boolean matchablePassport) {
        if (null == env) {
            throw new XQERuntimeException(XQEMessageKeys.GEN_ExecutionEnvironmentMissing_INTERNAL);
        }
        IRequestEnvironment requestEnv = env.getRequestEnvironment();
        if (null == requestEnv) {
            return;
        }
        String userIdentity = null;
        String defaultName = null;
        List identities = ContentManager.getIdentitiesList((IRequestEnvironment)requestEnv);
        for (int i = 0; i < identities.size(); ++i) {
            ICMSessionIdentity identity = (ICMSessionIdentity)identities.get(i);
            if (!ACCOUNT.equals(identity.getType())) continue;
            userIdentity = identity.getIdentity();
            defaultName = identity.getDefaultName();
            break;
        }
        if (null != userIdentity) {
            params.put((IConnectionParameter)new CMUserIdentity(userIdentity, defaultName, matchablePassport));
        }
    }

    public static String getUserName(IExecutionEnvironment env) {
        IRequestEnvironment requestEnv = env.getRequestEnvironment();
        if (null == requestEnv) {
            return null;
        }
        String userNamePropertyKey = "account.personalInfo." + ParameterMapCM.EPROPERTY.USERNAME.getKey();
        ICMUser cmUser = ContentManager.getUser((IRequestEnvironment)requestEnv);
        if (null != cmUser && null != cmUser.getParameterMap() && cmUser.getParameterMap().containsKey(userNamePropertyKey) && !((ArrayList)cmUser.getParameterMap().get(userNamePropertyKey)).isEmpty()) {
            return (String)((ArrayList)cmUser.getParameterMap().get(userNamePropertyKey)).get(0);
        }
        return null;
    }
}

