/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.ProviderIteratorBase;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCubeResultSet;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.metadata.TM1RESTMetadataLoader;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.data.types.BooleanType;
import com.cognos.xqe.data.types.DataTypeFactory;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.StringValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.RoleTypeEnum;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.Tuple;
import com.cognos.xqe.runtree.XDataContext;
import java.io.IOException;
import java.util.List;
import java.util.Locale;

public class TM1RESTAxisIterator
extends ProviderIteratorBase {
    private IJsonArray mJsonTupleChunk;
    private final long mCardinality;
    private final String mCellSetId;
    private final long mAxisOrdinal;
    private long mChunkOrdinal = 0L;
    private final RESTClient mRestClient;
    private final ExecutionEnvironment mExecutionEnvironment;
    private final Locale mLocale;
    private static int chunkSize = 65536;
    private static int chunkIndexMask = 65535;
    private static int chunkOrdinalShift = 16;
    private final IHierarchy[] mHierarchies;

    public TM1RESTAxisIterator(TM1RESTCubeResultSet rs, IJsonObject axis, RESTClient restClient, String cellSetId, XDataContext xDataContext, Integer nodeId) throws TM1RESTODPException {
        super((ProviderResultSetBase)rs, xDataContext, nodeId);
        try {
            if (xDataContext.getEnvironment() != null && xDataContext.getEnvironment() instanceof ExecutionEnvironment) {
                this.mExecutionEnvironment = (ExecutionEnvironment)xDataContext.getEnvironment();
                this.mLocale = ((RequestEnvironment)this.mExecutionEnvironment.getRequestEnvironment()).getRunLocale();
            } else {
                this.mExecutionEnvironment = null;
                this.mLocale = null;
            }
            this.mRestClient = restClient;
            this.mAxisOrdinal = axis.getLongValue("Ordinal");
            this.mCardinality = axis.getLongValue("Cardinality");
            this.mCellSetId = cellSetId;
            this.mJsonTupleChunk = this.getTupleArray(0L);
            ICube cube = rs.getCube();
            this.mHierarchies = this.getHierarchies(cube);
        }
        catch (IOException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
    }

    public static IDimension[] getDimensions(IJsonObject jsonHierarchySet, ICube cube) throws IOException {
        IDimension[] dimensionArray;
        if (jsonHierarchySet != null && !jsonHierarchySet.isEmpty()) {
            IJsonArray jsonHierarchyArray = jsonHierarchySet.getArray("value");
            dimensionArray = new IDimension[jsonHierarchyArray.size()];
            int i = 0;
            for (Object jsonHierarchy : jsonHierarchyArray) {
                IJsonObject jsonDimension = ((IJsonObject)jsonHierarchy).getJsonObject("Dimension");
                String dimUninqueName = jsonDimension.getStringValue("UniqueName");
                dimensionArray[i++] = cube.getDimension(dimUninqueName);
            }
        } else {
            dimensionArray = new IDimension[]{};
        }
        return dimensionArray;
    }

    public IHierarchy[] getHierarchies(ICube cube) throws IOException {
        IHierarchy[] hierarchyArray;
        String hierarchyUri = RESTUriBuilder.getHierarchyUri(this.mCellSetId, this.mAxisOrdinal, this.mRestClient.getUriBuilder());
        IJsonObject jsonHierarchySet = this.mRestClient.getJsonResource(hierarchyUri, this.mExecutionEnvironment);
        if (jsonHierarchySet != null && !jsonHierarchySet.isEmpty()) {
            IJsonArray jsonHierarchyArray = jsonHierarchySet.getArray("value");
            hierarchyArray = new IHierarchy[jsonHierarchyArray.size()];
            int i = 0;
            for (Object jsonHierarchy : jsonHierarchyArray) {
                String hierUninqueName = ((IJsonObject)jsonHierarchy).getStringValue("UniqueName");
                hierarchyArray[i++] = cube.getHierarchy(hierUninqueName);
            }
        } else {
            hierarchyArray = new IHierarchy[]{};
        }
        return hierarchyArray;
    }

    public static IHierarchy[] getHierarchies(IJsonObject jsonHierarchySet, ICube cube) {
        IHierarchy[] hierarchyArray;
        if (jsonHierarchySet != null && !jsonHierarchySet.isEmpty()) {
            IJsonArray jsonHierarchyArray = jsonHierarchySet.getArray("value");
            hierarchyArray = new IHierarchy[jsonHierarchyArray.size()];
            int i = 0;
            for (Object jsonHierarchy : jsonHierarchyArray) {
                String hierUninqueName = ((IJsonObject)jsonHierarchy).getStringValue("UniqueName");
                hierarchyArray[i++] = cube.getHierarchy(hierUninqueName);
            }
        } else {
            hierarchyArray = new IHierarchy[]{};
        }
        return hierarchyArray;
    }

    public Object nextImpl() {
        if (this.mHierarchies.length == 0) {
            return null;
        }
        try {
            ++this.currentIndex;
            return this.readTuple();
        }
        catch (IOException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
    }

    private ITuple readTuple() throws IOException {
        if (this.currentIndex < this.mCardinality) {
            long index;
            IJsonObject tuple;
            IJsonArray memberArray;
            IMember[] members = new IMember[this.mHierarchies.length];
            long chunkOrdinal = this.currentIndex >> chunkOrdinalShift;
            if (chunkOrdinal != this.mChunkOrdinal) {
                this.mJsonTupleChunk = this.getTupleArray(chunkOrdinal);
            }
            if ((memberArray = (tuple = (IJsonObject)this.mJsonTupleChunk.get((int)(index = this.currentIndex & (long)chunkIndexMask))).getArray("Members")).size() != this.mHierarchies.length) {
                throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, "memberArray.size() != dimensions.length");
            }
            for (int i = 0; i < this.mHierarchies.length; ++i) {
                members[i] = this.readMember(i, memberArray);
            }
            return new Tuple(members);
        }
        return null;
    }

    private IJsonArray getTupleArray(long chunkOrdinal) throws IOException {
        this.mChunkOrdinal = chunkOrdinal;
        ODataUriBuilder uriBuilder = this.mRestClient.getUriBuilder();
        String tupleChunkUri = RESTUriBuilder.getTuplesChunkUri(this.mCellSetId, this.mAxisOrdinal, chunkOrdinal * (long)chunkSize, chunkSize, uriBuilder);
        IJsonObject jsonTupleChunk = this.mRestClient.getJsonResource(tupleChunkUri, this.mExecutionEnvironment, this.mLocale, "application/json;odata.metadata=none");
        return jsonTupleChunk.getArray("value");
    }

    private IMember readMember(int tupleIndex, IJsonArray memberArray) {
        IHierarchy hierarchy;
        IJsonObject jsonMember = (IJsonObject)memberArray.get(tupleIndex);
        String memberMUN = jsonMember.getStringValue("UniqueName");
        IJsonObject jsonMemberHierarchy = jsonMember.getJsonObject("Hierarchy");
        String hierarchyHUN = jsonMemberHierarchy.getStringValue("UniqueName");
        if (!hierarchyHUN.equals((hierarchy = this.mHierarchies[tupleIndex]).getUniqueName())) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.MET_NONEXISTANT_HIERARCHY, hierarchyHUN);
        }
        Member member = this.getCachedMember(memberMUN);
        if (null != member) {
            return member;
        }
        member = new Member();
        member.setConnection(hierarchy.getDimension().getConnection());
        member.setUniqueName(memberMUN);
        String memberName = jsonMember.getStringValue("Name");
        member.setName(memberName);
        IJsonObject jsonMemberAtrributes = jsonMember.getJsonObject("Attributes");
        String description = null;
        String caption = null;
        if (jsonMemberAtrributes != null) {
            description = jsonMemberAtrributes.getStringValue("DESCRIPTION");
            caption = jsonMemberAtrributes.getStringValue("Caption");
        }
        if (description == null || description.isEmpty()) {
            description = memberName;
        }
        if (caption == null || caption.isEmpty()) {
            caption = memberName;
        }
        member.setDescription(description);
        member.setCaption(caption);
        member.setUniqueID(memberName);
        Long childrenCardinality = jsonMember.getLongValue("Children@odata.count");
        if (childrenCardinality != null) {
            member.setChildrenCardinality(childrenCardinality.intValue());
        }
        member.setProperty("MEMBER_KEY", (Object)memberName);
        IJsonObject jsonMemberLevel = jsonMember.getJsonObject("Level");
        Long levelNumber = jsonMemberLevel.getLongValue("Number");
        ILevel level = hierarchy.getLevel(levelNumber.intValue());
        member.setLevel(level);
        List levelProperties = level.getMemberProperties();
        for (IProperty prop : levelProperties) {
            BooleanType dataType;
            String propName = prop.getName();
            if (propName.equals("Member Caption_")) {
                propName = "Caption";
            } else if (propName.equals("Member Description")) {
                propName = "DESCRIPTION";
            }
            Object propValue = jsonMemberAtrributes.getObject(propName);
            if (null == propValue) continue;
            Value value = null;
            if (propValue instanceof Boolean) {
                dataType = DataTypeFactory.getBooleanType();
                value = (Value)dataType.createValue();
                boolean booleanValue = (Boolean)propValue;
                value.set(booleanValue);
            } else if (propValue instanceof Double) {
                dataType = DataTypeFactory.getDoubleType();
                value = (Value)dataType.createValue();
                value.set(propValue);
            } else if (propValue instanceof Integer) {
                dataType = DataTypeFactory.getIntegerType();
                value = (Value)dataType.createValue();
                value.set(propValue);
            } else if (propValue instanceof Long) {
                dataType = DataTypeFactory.getLongType();
                value = (Value)dataType.createValue();
                value.set(propValue);
            } else if (propValue instanceof String) {
                if (((String)propValue).isEmpty()) continue;
                dataType = DataTypeFactory.getStringType();
                value = (Value)dataType.createValue();
                value.set(propValue);
            }
            if (TM1RESTMetadataLoader.isDefaultProperty(propName)) {
                member.setProperty(propName, (Object)value);
            } else {
                member.setProperty(prop.getUniqueName(), (Object)value);
            }
            if (!prop.getRoles().contains(RoleTypeEnum.BUSINESS_KEY)) continue;
            member.setBusinessKey(value);
        }
        StringValue strValue = DataValueFactory.createStringValue();
        strValue.set(memberName);
        member.setBusinessKey((Value)strValue);
        IJsonObject jsonMemberParent = jsonMember.getJsonObject("Parent");
        if (null != jsonMemberParent) {
            String memberParentMUN = jsonMemberParent.getStringValue("UniqueName");
            member.setParentUniqueName(memberParentMUN);
            member.setParentLevelNumber(member.getLevel().getIndex() - 1);
        }
        this.putCachedMember(member);
        return member;
    }

    private Member getCachedMember(String mun) {
        TM1RESTCubeResultSet rs = (TM1RESTCubeResultSet)this.getResultSet();
        return rs.getCachedMember(mun);
    }

    private void putCachedMember(Member member) {
        TM1RESTCubeResultSet rs = (TM1RESTCubeResultSet)this.getResultSet();
        rs.putCachedMember(member);
    }

    public void releaseImpl() {
        this.currentIndex = -1L;
    }
}

