/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data;

import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.data.providers.DataProviderBase;
import com.cognos.xqe.data.providers.IProviderContextContainer;
import com.cognos.xqe.data.providers.ProviderResultSetBase;
import com.cognos.xqe.data.providers.olap.DefaultConnection;
import com.cognos.xqe.data.providers.olap.MDXQueryArguments;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTDataProvider;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTAxisIterator;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTCellIterator;
import com.cognos.xqe.data.providers.olap.tm1rest.data.TM1RESTScrollableCellIterator;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonArray;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.ODataUriBuilder;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.data.providers.olap.tm1rest.utils.RESTUriBuilder;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.provider.Member;
import com.cognos.xqe.pool.connection.IPooledConnection;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.resultset.interfaces.ICubeResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.resultsets.md.XCellIterator;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.XScrollableCellIterator;
import com.cognos.xqe.runtree.XScrollableIterator;
import com.cognos.xqe.trace.LogLevel;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class TM1RESTCubeResultSet
extends ProviderResultSetBase
implements ICubeResultSet,
IProviderContextContainer {
    private static final String MDX_WHERE = "WHERE";
    private final ICube modelCube;
    private final IPooledConnection pooledConnection;
    private final String cellSetId;
    private int numAxes = -1;
    IJsonArray jsonAxisArray;
    private int slicerAxisOrdinal;
    private IDimension[][] axisDimensions;
    private IHierarchy[][] axisHierarchies;
    private final Map<String, Member> memberCache = new HashMap<String, Member>();

    public TM1RESTCubeResultSet(TM1RESTDataProvider provider, IPooledConnection aPooledConnection, XDataContext xDataContext, MDXQueryArguments queryArguments, String aCellSetId) {
        super((DataProviderBase)provider, xDataContext, queryArguments.getRunLocale());
        this.pooledConnection = aPooledConnection;
        this.modelCube = queryArguments.getCube();
        this.slicerAxisOrdinal = -1;
        this.cellSetId = aCellSetId;
    }

    public void initialize(MDXQueryArguments queryArguments) {
        RESTClient restClient = ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServer();
        try {
            String axesUri;
            IJsonObject jsonAxisSet;
            ExecutionEnvironment env = null;
            if (this.getDataContext().getEnvironment() != null && this.getDataContext().getEnvironment() instanceof ExecutionEnvironment) {
                env = (ExecutionEnvironment)this.getDataContext().getEnvironment();
            }
            Locale aLocale = null;
            if (env != null && env.getRequestEnvironment() != null && ((RequestEnvironment)env.getRequestEnvironment()).getRunLocale() != null) {
                aLocale = ((RequestEnvironment)env.getRequestEnvironment()).getRunLocale();
            }
            if (!RESTClientResponse.validateAndLog(jsonAxisSet = restClient.getJsonResource(axesUri = RESTUriBuilder.getAxesUri(this.cellSetId, restClient.getUriBuilder()), env, aLocale), axesUri, ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServerName())) {
                return;
            }
            if (jsonAxisSet != null && !jsonAxisSet.isEmpty()) {
                this.jsonAxisArray = jsonAxisSet.getArray("value");
                if (this.jsonAxisArray != null && !this.jsonAxisArray.isEmpty()) {
                    String mdx;
                    this.numAxes = this.jsonAxisArray.size();
                    this.axisDimensions = new IDimension[this.numAxes][];
                    this.axisHierarchies = new IHierarchy[this.numAxes][];
                    int i = 0;
                    ODataUriBuilder uriBuilder = restClient.getUriBuilder();
                    for (Object currAxis : this.jsonAxisArray) {
                        long currOrdinal = ((IJsonObject)currAxis).getLongValue("Ordinal");
                        String hierarchyUri = RESTUriBuilder.getHierarchyUri(this.cellSetId, currOrdinal, uriBuilder.reset());
                        IJsonObject jsonHierarchySet = restClient.getJsonResource(hierarchyUri, env, aLocale);
                        RESTClientResponse.validateAndLog(jsonHierarchySet, hierarchyUri, ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServerName());
                        IDimension[] dimensions = TM1RESTAxisIterator.getDimensions(jsonHierarchySet, this.modelCube);
                        this.axisDimensions[i] = dimensions;
                        IHierarchy[] hierarchies = TM1RESTAxisIterator.getHierarchies(jsonHierarchySet, this.modelCube);
                        this.axisHierarchies[i++] = hierarchies;
                    }
                    if (this.axisDimensions[this.numAxes - 1].length == 0) {
                        --this.numAxes;
                    }
                    if ((mdx = queryArguments.getMDXQuery().getMDX()).contains(MDX_WHERE)) {
                        this.slicerAxisOrdinal = --this.numAxes;
                    }
                } else {
                    this.numAxes = 0;
                }
            }
        }
        catch (IOException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
    }

    public ICube getCube() {
        return this.modelCube;
    }

    public XIterator getAxisIterator(int axisNumber) {
        try {
            return new TM1RESTAxisIterator(this, (IJsonObject)this.jsonAxisArray.get(axisNumber), ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServer(), this.cellSetId, this.getDataContext(), this.nodeId);
        }
        catch (TM1RESTODPException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
    }

    public long getAxisSize(int axisNumber) {
        RESTClient restClient = ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServer();
        ODataUriBuilder uriBuilder = restClient.getUriBuilder();
        String uri = RESTUriBuilder.getAxisTuplesCardinalityUri(this.cellSetId, axisNumber, uriBuilder);
        try {
            String textResource = restClient.getTextResource(uri);
            return Long.parseLong(textResource);
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
    }

    public XCellIterator getCellIterator() {
        RESTClient restClient = ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServer();
        try {
            return new TM1RESTCellIterator(this, this.cellSetId, this.getDataContext(), this.nodeId, restClient);
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
    }

    public IDimension[] getDimensions(int axisNumber) {
        return this.axisDimensions[axisNumber];
    }

    public IHierarchy[] getHierarchies(int axisNumber) {
        return this.axisHierarchies[axisNumber];
    }

    public int getNumAxes() {
        return this.numAxes;
    }

    public int getNumDataItemForSummary(int rowsetId) {
        return 0;
    }

    public int getNumTabularMeasures() {
        return 0;
    }

    public XScrollableIterator getScrollableAxisIterator(int axisNumber) {
        throw new UnsupportedOperationException();
    }

    public XScrollableCellIterator getScrollableCellIterator() {
        RESTClient restClient = ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServer();
        return new TM1RESTScrollableCellIterator(this, this.cellSetId, this.getDataContext(), this.nodeId, restClient);
    }

    public ITuple getSlicer() {
        XIterator axisIter = this.getAxisIterator(this.slicerAxisOrdinal);
        try {
            ITuple iTuple = (ITuple)axisIter.next();
            return iTuple;
        }
        finally {
            axisIter.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void releaseImpl() {
        try {
            this.jsonAxisArray = null;
            RESTClient restClient = ((TM1RESTConnection)((Object)this.pooledConnection.getConnection())).getServer();
            if (restClient != null) {
                ODataUriBuilder uriBuilder = restClient.getUriBuilder();
                uriBuilder.entityId("Cellsets", this.cellSetId);
                try {
                    long respCode = restClient.deleteResource(uriBuilder.toString());
                    if (204L == respCode) {
                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_QUERY_RESULTSET, LogLevel.TRACE, "Cell set has been removed [%s].", this.cellSetId);
                    } else {
                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_QUERY_RESULTSET, LogLevel.TRACE, "Cell set had been removed [%s]. Response code=%d.", this.cellSetId, respCode);
                    }
                }
                catch (IOException e) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_QUERY_RESULTSET, LogLevel.TRACE, "Failed to remove the Cell set [%s].", this.cellSetId);
                }
            }
            this.pooledConnection.returnConnection();
            this.memberCache.clear();
        }
        finally {
            super.releaseImpl();
        }
    }

    void putCachedMember(Member member) {
        this.memberCache.put(member.getUniqueName(), member);
    }

    Member getCachedMember(String mun) {
        return this.memberCache.get(mun);
    }

    public Object[] getContext() {
        DefaultConnection connection = (DefaultConnection)this.pooledConnection.getConnection();
        return connection.getContext();
    }
}

