/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.data.providers.olap.tm1rest.data;

import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTConnection;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTLog;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTMessageKeys;
import com.cognos.xqe.data.providers.olap.tm1rest.TM1RESTODPException;
import com.cognos.xqe.data.providers.olap.tm1rest.data.resultSetViewer.BasicTM1RESTResultSet;
import com.cognos.xqe.data.providers.olap.tm1rest.json.BIJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonFactory;
import com.cognos.xqe.data.providers.olap.tm1rest.json.IJsonObject;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClient;
import com.cognos.xqe.data.providers.olap.tm1rest.restclient.RESTClientResponse;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.trace.LogLevel;
import java.io.IOException;

public class TM1RESTMDXQuery {
    private static final String ID_JSON_KEY = "ID";
    private static final String MDX_JSON_KEY = "MDX";
    private final TM1RESTConnection connection;
    private final ExecutionEnvironment execEnvironment;
    private static final IJsonFactory TM1_JSON_FACTORY = BIJsonFactory.getInstance();

    public TM1RESTMDXQuery(TM1RESTConnection aConnection, ExecutionEnvironment aEnvironment) {
        this.connection = aConnection;
        this.execEnvironment = aEnvironment;
    }

    public String execute(String mdx, ICube aCube) {
        int connectionId = System.identityHashCode((Object)this.connection);
        String datasetName = null;
        if (this.execEnvironment != null && this.execEnvironment.getDataContext() != null) {
            datasetName = this.execEnvironment.getDataContext().getRsapiDatasetName();
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_MDX, LogLevel.TRACE, "Began query execution [CONNECTION_ID=%d, RsapiDatasetName=%s].", connectionId, datasetName);
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_MDX, LogLevel.INFO, "MDX query string: \n%s", mdx);
        String cellSetID = null;
        long startTime = System.currentTimeMillis();
        try {
            cellSetID = this.executeMDX(this.connection.getServer(), mdx);
        }
        catch (TM1RESTODPException e) {
            throw e;
        }
        catch (IOException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_TM1_ERROR_WITH_MESSAGE, e.getLocalizedMessage());
        }
        catch (RuntimeException e) {
            throw new TM1RESTODPException(TM1RESTMessageKeys.ERR_UNKNOWN_ERROR, e.getLocalizedMessage());
        }
        if (this.execEnvironment.getCancelManager().isRequestCancelled()) {
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_MDX_CANCEL, LogLevel.TRACE, "The server successfully cancelled the current query [CONNECTION_ID=%d] - query completed.", connectionId);
            throw new OperationCanceledException();
        }
        if (cellSetID != null && !cellSetID.isEmpty()) {
            long elapsedTime = System.currentTimeMillis() - startTime;
            TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_MDX, LogLevel.TRACE, "Finished query execution [CONNECTION_ID=%d, RsapiDatasetName=%s] in %d milliseconds.", connectionId, datasetName, elapsedTime);
            if (TM1RESTLog.DATA_VIEW.isOn(LogLevel.TRACE) || TM1RESTLog.DATA_VIEW_AXES.isOn(LogLevel.INFO) || TM1RESTLog.DATA_VIEW_CELLS.isOn(LogLevel.INFO)) {
                BasicTM1RESTResultSet basicTM1RESTResultSet = new BasicTM1RESTResultSet(cellSetID, this.connection.getServer(), this.execEnvironment);
                LogLevel logLevel = TM1RESTLog.DATA_VIEW.getLogLevel();
                LogLevel axeslogLevel = TM1RESTLog.DATA_VIEW_AXES.getLogLevel();
                LogLevel celllogLevel = TM1RESTLog.DATA_VIEW_CELLS.getLogLevel();
                if (logLevel != LogLevel.TRACE) {
                    logLevel = TM1RESTLog.DATA_VIEW_AXES.getLogLevel().ordinal() < TM1RESTLog.DATA_VIEW_CELLS.getLogLevel().ordinal() ? TM1RESTLog.DATA_VIEW_AXES.getLogLevel() : TM1RESTLog.DATA_VIEW_CELLS.getLogLevel();
                } else {
                    axeslogLevel = logLevel;
                    celllogLevel = logLevel;
                }
                basicTM1RESTResultSet.initialize(axeslogLevel, celllogLevel);
                if (LogLevel.TRACE == TM1RESTLog.DATA_VIEW.getLogLevel()) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_VIEW, logLevel, basicTM1RESTResultSet.toString(), new Object[0]);
                }
                if (LogLevel.INFO == TM1RESTLog.DATA_VIEW_AXES.getLogLevel()) {
                    int axesNum = basicTM1RESTResultSet.getAxisArray().length;
                    for (int i = 0; i < axesNum; ++i) {
                        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_VIEW_AXES, LogLevel.INFO, basicTM1RESTResultSet.axesToString(LogLevel.INFO), new Object[0]);
                    }
                }
                if (LogLevel.INFO == TM1RESTLog.DATA_VIEW_CELLS.getLogLevel()) {
                    TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_VIEW_CELLS, LogLevel.INFO, basicTM1RESTResultSet.cellsToString(LogLevel.INFO), new Object[0]);
                }
            }
            return cellSetID;
        }
        TM1RESTLog.TM1RESTLogWrapper.log(TM1RESTLog.DATA_MDX, LogLevel.ERROR, "Query execution [CONNECTION_ID=%d, RsapiDatasetName=%s] failed returning an invalid cellCetID.", connectionId, datasetName);
        return cellSetID;
    }

    private String executeMDX(RESTClient restClient, String mdxText) throws IOException {
        IJsonObject mdxJsonObj = TM1_JSON_FACTORY.createObject();
        mdxJsonObj.put(MDX_JSON_KEY, mdxText);
        IJsonObject jsonResponse = restClient.createResourceAsync(restClient.getExecuteMDXUri(), "application/json", mdxJsonObj, this.execEnvironment);
        RESTClientResponse.validateAndThrow(jsonResponse, mdxText, TM1RESTMessageKeys.ERR_MDX_EXECUTION_FAILURE);
        return jsonResponse.getStringValue(ID_JSON_KEY);
    }
}

